/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ui.preferences.PreferencesHelper;
import org.eclipse.ease.ui.scripts.FileScriptStorage;
import org.eclipse.ease.ui.scripts.WorkspaceScriptStorage;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ui.PlatformUI;

public abstract class ScriptStorage {
    private final String fLocation;

    public static ScriptStorage createStorage() {
        String location = PreferencesHelper.getScriptStorageLocation();
        if (location.startsWith("workspace://")) {
            return new WorkspaceScriptStorage(location);
        }
        return new FileScriptStorage(location);
    }

    protected ScriptStorage(String location) {
        this.fLocation = location;
    }

    public boolean exists(String name) {
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        return repositoryService.getScript(name) != null;
    }

    public boolean store(String name, String content) {
        Path path = new Path(name);
        if (this.createPath(path.removeLastSegments(1)) && this.createFile(path, content)) {
            IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
            repositoryService.update(false);
            return true;
        }
        return false;
    }

    public String getLocation() {
        return this.fLocation;
    }

    protected abstract boolean createFile(Path var1, String var2);

    protected abstract boolean createPath(IPath var1);
}

