/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ease.lang.unittest.definition.ICode;
import org.eclipse.ease.lang.unittest.definition.IDefinitionFactory;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.ease.lang.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class CustomCodePage
extends AbstractEditorPage {
    private boolean fEnableChangeTracker = true;
    private Text fTxtCode;
    private ComboViewer fCmbCodeLocation;

    private static String getDefaultText(String location) {
        if ("TestSuite Setup".equals(location)) {
            return "// Testsuite setup is run once before test files are run.\n// To raise errors use the failure(\"Reason\") function.\n// Variables are already available in setup code.\n";
        }
        if ("TestSuite Teardown".equals(location)) {
            return "// Testsuite teardown is run once after all test files are finished.";
        }
        if ("TestFile Setup".equals(location)) {
            return "// Testfile setup is run at the beginning of a test file,\n// right before the script code is executed.\n// Variables are available in setup code.\n";
        }
        if ("TestFile Teardown".equals(location)) {
            return "// Testfile teardown is run at the end of each test file.\n";
        }
        return "";
    }

    public CustomCodePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(2, false));
        Label lblCustomCodeUsed = new Label(managedForm.getForm().getBody(), 0);
        lblCustomCodeUsed.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)lblCustomCodeUsed, true, true);
        lblCustomCodeUsed.setText("Custom code used to setup test suites, sets and tests. To run custom code actions use executeUserCode(<location>); in your scripts.");
        Label label = new Label(managedForm.getForm().getBody(), 0);
        managedForm.getToolkit().adapt((Control)label, true, true);
        new Label(managedForm.getForm().getBody(), 0);
        Label lblLocation = new Label(managedForm.getForm().getBody(), 0);
        lblLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)lblLocation, true, true);
        lblLocation.setText("Location:");
        CCombo combo_1 = new CCombo(managedForm.getForm().getBody(), 0x800008);
        GridData gd_combo_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_combo_1.widthHint = 300;
        combo_1.setLayoutData((Object)gd_combo_1);
        combo_1.setEditable(true);
        combo_1.setVisibleItemCount(10);
        combo_1.setLayoutData((Object)gd_combo_1);
        this.fCmbCodeLocation = new ComboViewer(combo_1);
        managedForm.getToolkit().paintBordersFor((Composite)combo_1);
        this.fCmbCodeLocation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fCmbCodeLocation.setInput(this.getLocations());
        this.fCmbCodeLocation.addSelectionChangedListener(event -> {
            String location = ((IStructuredSelection)event.getSelection()).getFirstElement().toString();
            ICode customCode = this.getTestSuiteDefinition().getCustomCode(location);
            String code = customCode != null ? customCode.getContent() : null;
            this.fEnableChangeTracker = false;
            this.fTxtCode.setText(code != null ? code : CustomCodePage.getDefaultText(location));
            this.fEnableChangeTracker = true;
        });
        this.fTxtCode = new Text(managedForm.getForm().getBody(), 578);
        this.fTxtCode.addModifyListener(e -> {
            Object element;
            if (this.fEnableChangeTracker && (element = this.fCmbCodeLocation.getStructuredSelection().getFirstElement()) != null) {
                String location = element.toString();
                ICode code = this.getTestSuiteDefinition().getCustomCode(location);
                if (code != null) {
                    Command command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)code, (Object)IDefinitionPackage.Literals.CODE__CONTENT, (Object)this.fTxtCode.getText());
                    this.getEditor().executeCommand(command);
                } else {
                    ICode customCode = IDefinitionFactory.eINSTANCE.createCode();
                    customCode.setLocation(location);
                    customCode.setContent(this.fTxtCode.getText());
                    Command command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__CUSTOM_CODE, (Object)customCode);
                    this.getEditor().executeCommand(command);
                }
            }
        });
        GridData gd_txtCode = new GridData(4, 4, true, true, 2, 1);
        gd_txtCode.verticalIndent = 10;
        this.fTxtCode.setLayoutData((Object)gd_txtCode);
        managedForm.getToolkit().adapt((Control)this.fTxtCode, true, true);
    }

    private Collection<String> getLocations() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TestSuite Setup");
        result.add("TestFile Setup");
        result.add("TestFile Teardown");
        result.add("TestSuite Teardown");
        for (ICode code : this.getTestSuiteDefinition().getCustomCode()) {
            if (result.contains(code.getLocation())) continue;
            result.add(code.getLocation());
        }
        return result;
    }

    @Override
    protected String getPageTitle() {
        return "Custom Code";
    }

    @Override
    protected void populateContent() {
        this.fCmbCodeLocation.setInput(this.getLocations());
    }

    public Image getTitleImage() {
        return Activator.getImage("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/custom_code.png", true);
    }
}

