/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.tools;

import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.SelectConnectionEditPartTracker;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SequenceMessageSelectConnectionEditPartTracker
extends SelectConnectionEditPartTracker
implements DragTracker {
    private boolean fromTop = true;
    private BendpointRequest bendpointRequest;
    private boolean msgToSelfMove;

    public SequenceMessageSelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super(owner);
    }

    protected Request createSourceRequest() {
        Request rq = super.createSourceRequest();
        if (rq instanceof BendpointRequest) {
            this.bendpointRequest = (BendpointRequest)rq;
        }
        return rq;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        if (this.bendpointRequest != null) {
            Map extData = this.bendpointRequest.getExtendedData();
            if (this.msgToSelfMove) {
                extData.put("messageToSelfTopMove", this.fromTop);
            } else {
                extData.remove("messageToSelfTopMove");
            }
        }
    }

    protected boolean handleButtonDown(int button) {
        boolean res = super.handleButtonDown(button);
        SequenceMessageEditPart smep = (SequenceMessageEditPart)this.getSourceEditPart();
        if (new ISequenceEventQuery(smep.getISequenceEvent()).isReflectiveMessage()) {
            Range range = smep.getISequenceEvent().getVerticalRange();
            Point location = this.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)smep);
            Connection connection = smep.getConnectionFigure();
            int x = connection.getPoints().getMidpoint().x;
            if (x == location.x) {
                this.msgToSelfMove = false;
            } else {
                this.fromTop = location.y <= range.getLowerBound() || location.y < range.middleValue();
                this.msgToSelfMove = true;
            }
        }
        return res;
    }
}

