/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.dialect;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.HeaderData;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class SetBestHeightHeaderCommand
extends RecordingCommand {
    private Diagram diagram;

    public SetBestHeightHeaderCommand(TransactionalEditingDomain domain, Diagram diagram) {
        super(domain, Messages.SetBestHeightHeaderCommand_label);
        this.diagram = diagram;
    }

    protected void doExecute() {
        LinkedList headerDatas = Lists.newLinkedList();
        if (this.diagram.getElement() instanceof DDiagram) {
            DDiagram dDiagram = (DDiagram)this.diagram.getElement();
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(dDiagram.getDescription().eClass().getEPackage())) continue;
                headerDatas = diagramTypeDescriptor.getDiagramDescriptionProvider().getHeaderData(dDiagram);
                break;
            }
            int nbLines = this.getNbLinesNeeded(headerDatas);
            dDiagram.setHeaderHeight(nbLines);
        }
    }

    private int getNbLinesNeeded(List<HeaderData> headerDatas) {
        int maxNbLines = 1;
        for (HeaderData headerData : headerDatas) {
            int nbLines = SWTUtil.getNbLines((String)headerData.getName(), (int)headerData.getWidth());
            if (maxNbLines >= nbLines) continue;
            maxNbLines = nbLines;
        }
        return maxNbLines;
    }
}

