/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramImageUtils;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class ResetOriginChangeModelOperation
extends AbstractModelChangeOperation<Void> {
    private GraphicalEditPart containerEditPart;
    private int MARGIN = 20;
    private List<Connection> maskedConnections = new ArrayList<Connection>();

    public ResetOriginChangeModelOperation(DiagramEditPart diagramEditPart) {
        this.containerEditPart = diagramEditPart;
    }

    public ResetOriginChangeModelOperation(AbstractDiagramContainerEditPart containerEditPart) {
        this.containerEditPart = containerEditPart;
    }

    @Override
    public String getName() {
        String name = Messages.ResetOriginChangeModelOperation_name;
        if (this.containerEditPart instanceof DiagramEditPart) {
            name = Messages.ResetOriginChangeModelOperation_nameOnDiagram;
        } else if (this.containerEditPart instanceof AbstractDiagramContainerEditPart) {
            name = Messages.ResetOriginChangeModelOperation_nameOnContainer;
        }
        return name;
    }

    @Override
    public Void execute() {
        this.routeInvalidEdges();
        List<?> primaryEditParts = this.getPrimaryEditParts();
        this.removeInvalidEdges(primaryEditParts);
        ArrayList primaryGraphicalEditParts = Lists.newArrayList((Iterable)Iterables.filter(primaryEditParts, IGraphicalEditPart.class));
        Point topLeft = this.calculateBoundinBox(primaryGraphicalEditParts).getLocation();
        this.shiftAllTopDiagramElements(primaryGraphicalEditParts, topLeft);
        if (!topLeft.equals((Object)new Point(0, 0))) {
            for (Connection currentConnection : this.maskedConnections) {
                currentConnection.getPoints().performTranslate(-topLeft.x, -topLeft.y);
            }
        }
        return null;
    }

    private void routeInvalidEdges() {
        if (this.containerEditPart instanceof DiagramEditPart) {
            List connections = ((DiagramEditPart)this.containerEditPart).getConnections();
            for (ConnectionEditPart connection : connections) {
                IFigure figure = connection.getFigure();
                Object model = connection.getModel();
                if (!(figure instanceof PolylineConnection) || !(model instanceof Edge) || figure.isVisible() || !((Edge)model).isVisible()) continue;
                figure.setVisible(true);
                ((PolylineConnection)figure).layout();
                figure.setVisible(false);
                this.maskedConnections.add((Connection)figure);
            }
        }
    }

    private void shiftAllTopDiagramElements(List<IGraphicalEditPart> editParts, Point topLeft) {
        for (IGraphicalEditPart editPart : editParts) {
            LayoutConstraint constraint;
            if (editPart instanceof ConnectionEditPart || !(editPart.getModel() instanceof Node) || !((constraint = ((Node)editPart.getModel()).getLayoutConstraint()) instanceof Location)) continue;
            Location location = (Location)constraint;
            location.setX(location.getX() - topLeft.x());
            location.setY(location.getY() - topLeft.y());
        }
    }

    private Rectangle calculateBoundinBox(List<IGraphicalEditPart> editParts) {
        Rectangle result = null;
        if (this.containerEditPart instanceof DiagramEditPart) {
            result = DiagramImageUtils.calculateImageRectangle(editParts, (double)this.MARGIN, (Dimension)new Dimension(0, 0));
        } else if (this.containerEditPart instanceof AbstractDiagramContainerEditPart) {
            result = ResetOriginChangeModelOperation.calculateBoundinBoxRelativeToContainer(editParts, this.MARGIN, new Dimension(0, 0));
        }
        if (result == null) {
            result = new Rectangle();
        }
        return result;
    }

    private void removeInvalidEdges(List<?> primaryEditParts) {
        Iterator<?> iterator = primaryEditParts.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof AbstractConnectionEditPart)) continue;
            IFigure figure = ((AbstractConnectionEditPart)next).getFigure();
            Object model = ((AbstractConnectionEditPart)next).getModel();
            if (!(model instanceof View) || ((View)model).isVisible() || figure.isVisible()) continue;
            iterator.remove();
        }
    }

    List<?> getPrimaryEditParts() {
        List result = null;
        if (this.containerEditPart instanceof DiagramEditPart) {
            result = ((DiagramEditPart)this.containerEditPart).getPrimaryEditParts();
        } else {
            for (Object child : this.containerEditPart.getChildren()) {
                if (!(child instanceof AbstractDNodeContainerCompartmentEditPart)) continue;
                result = ((AbstractDNodeContainerCompartmentEditPart)child).getChildren();
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public static final Rectangle calculateBoundinBoxRelativeToContainer(List<IGraphicalEditPart> editparts, double frameSize, Dimension defaultSize) {
        double minX = editparts.isEmpty() ? 0.0 : Double.MAX_VALUE;
        double maxX = editparts.isEmpty() ? 0.0 : Double.MIN_VALUE;
        double minY = editparts.isEmpty() ? 0.0 : Double.MAX_VALUE;
        double maxY = editparts.isEmpty() ? 0.0 : Double.MIN_VALUE;
        for (IGraphicalEditPart editPart : editparts) {
            IFigure figure = editPart.getFigure();
            Rectangle bounds = null;
            bounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
            minX = Math.min(minX, bounds.preciseX());
            maxX = Math.max(maxX, bounds.preciseX() + bounds.preciseWidth());
            minY = Math.min(minY, bounds.preciseY());
            maxY = Math.max(maxY, bounds.preciseY() + bounds.preciseHeight());
        }
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.setPreciseWidth(maxX - minX);
        rect.setPreciseHeight(maxY - minY);
        if (defaultSize != null) {
            if (rect.preciseHeight() <= 0.0) {
                rect.setPreciseHeight(defaultSize.preciseWidth());
            }
            if (rect.preciseHeight() <= 0.0) {
                rect.setPreciseHeight(defaultSize.preciseHeight());
            }
        }
        rect.setPreciseX(minX - frameSize);
        rect.setPreciseY(minY - frameSize);
        rect.setPreciseWidth(rect.preciseWidth() + 2.0 * frameSize);
        rect.setPreciseHeight(rect.preciseHeight() + 2.0 * frameSize);
        return rect;
    }
}

