/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.operations;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class SiriusElementMappingSpecOperations {
    private SiriusElementMappingSpecOperations() {
    }

    public static boolean checkPrecondition(DiagramElementMapping mapping, EObject modelElement, EObject container, EObject containerView) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        boolean result = true;
        if (container != null) {
            interpreter.setVariable("container", (Object)container);
        }
        if (containerView != null) {
            interpreter.setVariable("containerView", (Object)containerView);
        }
        if (mapping.getPreconditionExpression() != null && !StringUtil.isEmpty((String)mapping.getPreconditionExpression().trim())) {
            result = false;
            try {
                result = interpreter.evaluateBoolean(modelElement, mapping.getPreconditionExpression());
            }
            catch (EvaluationException evaluationException) {}
        }
        if (container != null) {
            interpreter.unSetVariable("container");
        }
        if (containerView != null) {
            interpreter.unSetVariable("containerView");
        }
        return result;
    }

    public static boolean isFrom(DiagramElementMapping mapping, DMappingBased element) {
        if (element.getMapping() != null) {
            return new DiagramElementMappingQuery(mapping).isTypeOf(element);
        }
        return false;
    }
}

