/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Customization;
import org.eclipse.sirius.viewpoint.description.DecorationDescriptionsSet;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;

public class RepresentationExtensionDescriptionRegexConstraint
extends AbstractModelConstraint {
    private static final String ERROR_MESSAGE = Messages.RepresentationExtensionDescriptionRegexConstraint_errorMsg;
    private static final Pattern REGEX_PATTERN = Pattern.compile("[^\\?\\*\\[\\]\\(\\)]*");

    public IStatus validate(IValidationContext ctx) {
        IStatus status = null;
        EObject target = ctx.getTarget();
        if (target instanceof RepresentationExtensionDescription) {
            RepresentationExtensionDescription representationExtensionDescription = (RepresentationExtensionDescription)target;
            Matcher representationNameMatcher = REGEX_PATTERN.matcher(representationExtensionDescription.getRepresentationName());
            Matcher viewpointURIMatcher = REGEX_PATTERN.matcher(representationExtensionDescription.getViewpointURI());
            if (representationNameMatcher.matches() && viewpointURIMatcher.matches()) {
                status = ctx.createSuccessStatus();
            } else if (!Iterables.all((Iterable)representationExtensionDescription.eContents(), (Predicate)Predicates.instanceOf(AdditionalLayer.class))) {
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(ERROR_MESSAGE, representationExtensionDescription.getName())});
            } else if (!(representationExtensionDescription instanceof DiagramExtensionDescription)) {
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(ERROR_MESSAGE, representationExtensionDescription.getName())});
            } else {
                for (AdditionalLayer additionalLayer : ((DiagramExtensionDescription)representationExtensionDescription).getLayers()) {
                    if (Iterables.all((Iterable)additionalLayer.eContents(), (Predicate)Predicates.or((Predicate)Predicates.instanceOf(DecorationDescriptionsSet.class), (Predicate)Predicates.instanceOf(Customization.class)))) continue;
                    status = ctx.createFailureStatus(new Object[]{MessageFormat.format(ERROR_MESSAGE, representationExtensionDescription.getName())});
                }
            }
        }
        if (status == null) {
            status = ctx.createSuccessStatus();
        }
        return status;
    }
}

