/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.actions.analysis.IAddModelDependencyWizard;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.IAddModelDependencyWizardDescriptor;

public final class IAddModelDependencyWizardRegistry {
    private static final Collection<IAddModelDependencyWizardDescriptor> WIZARDS = Sets.newLinkedHashSet();

    private IAddModelDependencyWizardRegistry() {
    }

    public static void addWizard(IAddModelDependencyWizardDescriptor extension) {
        WIZARDS.add(extension);
    }

    public static void clearRegistry() {
        WIZARDS.clear();
    }

    public static IAddModelDependencyWizard getCreateOrAddModelDependencyWizard(Collection<Session> availableSessions) {
        for (IAddModelDependencyWizardDescriptor descriptor : IAddModelDependencyWizardRegistry.getRegisteredExtensions()) {
            IAddModelDependencyWizard wizard = descriptor.getWizard();
            if (!wizard.canApply(availableSessions)) continue;
            return wizard;
        }
        return null;
    }

    private static Collection<IAddModelDependencyWizardDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (IAddModelDependencyWizardDescriptor extension : WIZARDS) {
            registeredExtensions.add(extension);
        }
        return registeredExtensions;
    }

    public static void removeExtension(String extensionClassName) {
        for (IAddModelDependencyWizardDescriptor extension : IAddModelDependencyWizardRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            WIZARDS.remove(extension);
        }
    }
}

