/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.mapping;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.internal.EMFValuePropertyDecorator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.SegmentConverterValueResultImpl;
import org.eclipse.emfforms.internal.core.services.segments.mapping.EMFMappingValueProperty;
import org.eclipse.emfforms.internal.core.services.segments.mapping.IllegalMapTypeException;
import org.eclipse.emfforms.internal.core.services.segments.mapping.MappedSetting;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterListResultEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterValueResultEMF;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;

@Component(name="MappingSegmentConverter")
public class MappingSegmentConverter
implements DomainModelReferenceSegmentConverterEMF {
    public double isApplicable(VDomainModelReferenceSegment segment) {
        Assert.create((Object)segment).notNull();
        if (segment instanceof VMappingDomainModelReferenceSegment) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public SegmentConverterValueResultEMF convertToValueProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        VMappingDomainModelReferenceSegment mappingSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = segmentRoot.getEStructuralFeature(mappingSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new DatabindingFailedException(String.format("The given EOject does not contain the segment's feature. The segment was %1$s. The EObject was %2$s.", segment, segmentRoot));
        }
        this.checkMapType(structuralFeature);
        EClass eClass = (EClass)structuralFeature.getEType();
        EReference valueReference = (EReference)eClass.getEStructuralFeature("value");
        EMFMappingValueProperty mappingProperty = new EMFMappingValueProperty(editingDomain, mappingSegment.getMappedClass(), structuralFeature);
        EMFValuePropertyDecorator resultProperty = new EMFValuePropertyDecorator((IValueProperty)mappingProperty, structuralFeature);
        if (valueReference.getEReferenceType().isSuperTypeOf(mappingSegment.getMappedClass())) {
            return new SegmentConverterValueResultImpl((IEMFValueProperty)resultProperty, mappingSegment.getMappedClass());
        }
        return new SegmentConverterValueResultImpl((IEMFValueProperty)resultProperty, valueReference.getEReferenceType());
    }

    public SegmentConverterListResultEMF convertToListProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        throw new UnsupportedOperationException("A VMappingDomainModelReferenceSegment cannot be converted to a list property, only to a value property.");
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReferenceSegment segment, EObject eObject) throws DatabindingFailedException {
        VMappingDomainModelReferenceSegment mappingSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = eObject.eClass().getEStructuralFeature(mappingSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new DatabindingFailedException(String.format("The given EOject does not contain the segment's feature. The segment was %1$s. The EObject was %2$s.", segment, eObject));
        }
        this.checkMapType(structuralFeature);
        return new MappedSetting(eObject, structuralFeature, mappingSegment.getMappedClass());
    }

    private VMappingDomainModelReferenceSegment checkAndConvertSegment(VDomainModelReferenceSegment segment) throws DatabindingFailedException {
        Assert.create((Object)segment).notNull();
        Assert.create((Object)segment).ofClass(VMappingDomainModelReferenceSegment.class);
        VMappingDomainModelReferenceSegment mappingSegment = (VMappingDomainModelReferenceSegment)segment;
        if (mappingSegment.getDomainModelFeature() == null) {
            throw new DatabindingFailedException("The segment's domain model feature must not be null.");
        }
        if (mappingSegment.getDomainModelFeature().isEmpty()) {
            throw new DatabindingFailedException("The segment's domain model feature must not be an empty string.");
        }
        if (mappingSegment.getMappedClass() == null) {
            throw new DatabindingFailedException("The mapping segment's mapped class must not be null.");
        }
        return mappingSegment;
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        this.checkStructuralFeature(structuralFeature);
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null || valueFeature == null) {
            throw new IllegalMapTypeException("The segment's structural feature must reference a map.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new IllegalMapTypeException("The keys of the map referenced by the segment's structural feature must be referenced EClasses.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new IllegalMapTypeException("The keys of the map referenced by the segment's structural feature must be referenced EClasses.");
        }
        if (!EReference.class.isInstance(valueFeature)) {
            throw new IllegalMapTypeException("The values of the map referenced by the segment's structural feature must be referenced EObjects.");
        }
    }

    private void checkStructuralFeature(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        if (structuralFeature.getEType() == null) {
            throw new IllegalMapTypeException("The EType of the segment's structural feature was null.");
        }
        if (structuralFeature.getEType().getInstanceClassName() == null) {
            throw new IllegalMapTypeException("The InstanceClassName of the segment's structural feature's EType was null.");
        }
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new IllegalMapTypeException("The segment's structural feature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new IllegalMapTypeException("The segment's structural feature must reference a map.");
        }
    }
}

