/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;

public class TableViewerColumnBuilder {
    private Boolean isResizable;
    private Boolean isMoveable;
    private String text;
    private String tooltip;
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private Integer width;
    private Integer style = 0;

    public static TableViewerColumnBuilder create() {
        return new TableViewerColumnBuilder();
    }

    public TableViewerColumnBuilder setText(String text) {
        this.text = text;
        return this;
    }

    public TableViewerColumnBuilder setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public TableViewerColumnBuilder setResizable(boolean isResizable) {
        this.isResizable = isResizable;
        return this;
    }

    public TableViewerColumnBuilder setMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
        return this;
    }

    public TableViewerColumnBuilder setData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public TableViewerColumnBuilder setStyle(int style) {
        this.style = style;
        return this;
    }

    public TableViewerColumnBuilder setWidth(int width) {
        this.width = width;
        return this;
    }

    public TableViewerColumn build(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, this.style.intValue());
        this.setText(column);
        this.setToolTipText(column);
        this.setResizable(column);
        this.setMoveable(column);
        this.setData(column);
        this.setWidth(column);
        return column;
    }

    private void setText(TableViewerColumn column) {
        if (this.text != null) {
            column.getColumn().setText(this.text);
        }
    }

    private void setToolTipText(TableViewerColumn column) {
        if (this.tooltip != null) {
            column.getColumn().setToolTipText(this.tooltip);
        }
    }

    private void setResizable(TableViewerColumn column) {
        if (this.isResizable != null) {
            column.getColumn().setResizable(this.isResizable.booleanValue());
        }
    }

    private void setMoveable(TableViewerColumn column) {
        if (this.isMoveable != null) {
            column.getColumn().setMoveable(this.isMoveable.booleanValue());
        }
    }

    private void setData(TableViewerColumn column) {
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            column.getColumn().setData(entry.getKey(), entry.getValue());
        }
    }

    private void setWidth(TableViewerColumn column) {
        if (this.width != null) {
            column.getColumn().setWidth(this.width.intValue());
        }
    }
}

