/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Reference;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.SomeReference;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Visitor;

public class Cinema {
    private Optional<@NotBlank String> name;
    private Reference<@Valid @NotNull Visitor> visitor;

    private Cinema(String name, Reference<Visitor> visitor) {
        this.name = Optional.ofNullable(name);
        this.visitor = visitor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("<").append(this.name).append(">");
        return sb.toString();
    }

    public static Cinema invalidName() {
        return new Cinema("", null);
    }

    public static Cinema invalidReference() {
        return new Cinema("Comoedia", new SomeReference<Object>(null));
    }

    public static Cinema invalidVisitor() {
        return new Cinema("Comoedia", new SomeReference<Visitor>(new Visitor()));
    }
}

