/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Payload;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.CustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class CustomPropertyPathTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)CustomPropertyPathTest.webArchiveBuilder().withTestClass(CustomPropertyPathTest.class)).withClasses(CustomParameterNameProvider.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="ax")})
    public void testAddPropertyNode() {
        Set constraintViolations = this.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("myNode1"), ConstraintViolationAssert.pathWith().property("myNode2").property("myNode3"), ConstraintViolationAssert.pathWith().property("myNode4").property("myNode5", true, null, null), ConstraintViolationAssert.pathWith().property("myNode6").property("myNode7", true, null, 42), ConstraintViolationAssert.pathWith().property("myNode8").property("myNode9", true, "Foo", null), ConstraintViolationAssert.pathWith().property("myNode10").property("myNode11", true, null, null).property("myNode12"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="ay")})
    public void testAddBeanNode() {
        Set constraintViolations = this.getValidator().validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("address").bean(), ConstraintViolationAssert.pathWith().property("address").property("myNode1").bean(), ConstraintViolationAssert.pathWith().property("address").property("myNode2", true, null, null).bean(), ConstraintViolationAssert.pathWith().property("address").property("myNode3", true, null, 84).bean(), ConstraintViolationAssert.pathWith().property("address").property("myNode4", true, "AnotherKey", null).bean(), ConstraintViolationAssert.pathWith().property("address").bean(true, null, null), ConstraintViolationAssert.pathWith().property("address").bean(true, null, 42), ConstraintViolationAssert.pathWith().property("address").bean(true, "Key", null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="ax"), @SpecAssertion(section="validationapi-constraintviolation", id="bb"), @SpecAssertion(section="validationapi-constraintviolation", id="bd"), @SpecAssertion(section="validationapi-constraintviolation", id="be")})
    public void testAddingNodesInClassLevelConstraintKeepsInIterableKeyAndIndex() {
        Set constraintViolations = this.getValidator().validate((Object)new FooContainer(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("fooList").property("myNode1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("fooList").property("myNode2", true, null, 1, List.class, 0).property("myNode3"), ConstraintViolationAssert.pathWith().property("fooList").property("myNode4", true, null, 1, List.class, 0).property("myNode5", true, null, null), ConstraintViolationAssert.pathWith().property("fooList").property("myNode6", true, null, 1, List.class, 0).property("myNode7", true, null, 42), ConstraintViolationAssert.pathWith().property("fooList").property("myNode8", true, null, 1, List.class, 0).property("myNode9", true, "Foo", null), ConstraintViolationAssert.pathWith().property("fooList").property("myNode10", true, null, 1, List.class, 0).property("myNode11", true, null, null).property("myNode12"), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode1", true, null, 1, Object[].class, null), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode2", true, null, 1, Object[].class, null).property("myNode3"), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode4", true, null, 1, Object[].class, null).property("myNode5", true, null, null), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode6", true, null, 1, Object[].class, null).property("myNode7", true, null, 42), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode8", true, null, 1, Object[].class, null).property("myNode9", true, "Foo", null), ConstraintViolationAssert.pathWith().property("fooArray").property("myNode10", true, null, 1, Object[].class, null).property("myNode11", true, null, null).property("myNode12"), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode1", true, null, null, Set.class, 0), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode2", true, null, null, Set.class, 0).property("myNode3"), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode4", true, null, null, Set.class, 0).property("myNode5", true, null, null), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode6", true, null, null, Set.class, 0).property("myNode7", true, null, 42), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode8", true, null, null, Set.class, 0).property("myNode9", true, "Foo", null), ConstraintViolationAssert.pathWith().property("fooSet").property("myNode10", true, null, null, Set.class, 0).property("myNode11", true, null, null).property("myNode12"), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode1", true, "MapKey", null, Map.class, 1), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode2", true, "MapKey", null, Map.class, 1).property("myNode3"), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode4", true, "MapKey", null, Map.class, 1).property("myNode5", true, null, null), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode6", true, "MapKey", null, Map.class, 1).property("myNode7", true, null, 42), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode8", true, "MapKey", null, Map.class, 1).property("myNode9", true, "Foo", null), ConstraintViolationAssert.pathWith().property("fooMap").property("myNode10", true, "MapKey", null, Map.class, 1).property("myNode11", true, null, null).property("myNode12"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="az")})
    public void testAddParameterNode() throws Exception {
        Object[] parameterValues = new Object[]{Collections.emptyMap()};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)new User(), User.class.getMethod("setAddresses", Map.class), parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("setAddresses").parameter("addresses", 0), ConstraintViolationAssert.pathWith().method("setAddresses").parameter("addresses", 0).bean(), ConstraintViolationAssert.pathWith().method("setAddresses").parameter("addresses", 0).property("myNode1", true, null, 23).bean());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="az")})
    public void testAddParameterNodeUsingCustomParameterNameProvider() throws Exception {
        ExecutableValidator executableValidator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).buildValidatorFactory().getValidator().forExecutables();
        Object[] parameterValues = new Object[]{Collections.emptyMap()};
        Set constraintViolations = executableValidator.validateParameters((Object)new User(), User.class.getMethod("setAddresses", Map.class), parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().method("setAddresses").parameter("param0", 0), ConstraintViolationAssert.pathWith().method("setAddresses").parameter("param0", 0).bean(), ConstraintViolationAssert.pathWith().method("setAddresses").parameter("param0", 0).property("myNode1", true, null, 23).bean());
    }

    @Test(expectedExceptions={Exception.class})
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="az")})
    public void testAddParameterNodeForFieldLevelConstraintCausesException() throws Throwable {
        this.getValidator().validate((Object)new Bar(), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="bb"), @SpecAssertion(section="validationapi-constraintviolation", id="bc"), @SpecAssertion(section="validationapi-constraintviolation", id="bd"), @SpecAssertion(section="validationapi-constraintviolation", id="be")})
    public void testAddInContainerPropertyNodes() throws Throwable {
        Set constraintViolations = this.getValidator().validate((Object)new InContainerBean(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("property").property("myNode1").property("myNode2", true, "key", null, Map.class, 1).bean(), ConstraintViolationAssert.pathWith().property("property").property("myNode3", true, null, 3, List.class, 0).bean(), ConstraintViolationAssert.pathWith().property("property").property("myNode4", false, null, null, Optional.class, 0).property("myNode5"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="aw"), @SpecAssertion(section="validationapi-constraintviolation", id="ba"), @SpecAssertion(section="validationapi-constraintviolation", id="bb"), @SpecAssertion(section="validationapi-constraintviolation", id="bd"), @SpecAssertion(section="validationapi-constraintviolation", id="be")})
    public void testAddContainerElementNodes() throws Throwable {
        Set constraintViolations = this.getValidator().validate((Object)new ContainerElementNodeBean(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("property").containerElement("myNode1", true, "key", null, Map.class, 1), ConstraintViolationAssert.pathWith().property("property").containerElement("myNode2", true, "key", null, Map.class, 1).containerElement("myNode3", true, null, 8, List.class, 0).containerElement("myNode4", false, null, null, Optional.class, 0));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface PropertyLevelValidationAddingContainerElementNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<PropertyLevelValidationAddingContainerElementNodes, String> {
            public boolean isValid(String value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addContainerElementNode("myNode1", Map.class, Integer.valueOf(1)).inIterable().atKey((Object)"key").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addContainerElementNode("myNode2", Map.class, Integer.valueOf(1)).inIterable().atKey((Object)"key").addContainerElementNode("myNode3", List.class, Integer.valueOf(0)).inIterable().atIndex(Integer.valueOf(8)).addContainerElementNode("myNode4", Optional.class, Integer.valueOf(0)).addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface PropertyLevelValidationAddingInContainerPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<PropertyLevelValidationAddingInContainerPropertyNodes, String> {
            public boolean isValid(String value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode1").addPropertyNode("myNode2").inContainer(Map.class, Integer.valueOf(1)).inIterable().atKey((Object)"key").addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode3").inContainer(List.class, Integer.valueOf(0)).inIterable().atIndex(Integer.valueOf(3)).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode4").inContainer(Optional.class, Integer.valueOf(0)).addPropertyNode("myNode5").addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface FieldLevelValidationAddingParameterNode {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<FieldLevelValidationAddingParameterNode, String> {
            public boolean isValid(String value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface CrossParameterValidationAddingParameterBeanAndPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
        public static class Validator
        implements ConstraintValidator<CrossParameterValidationAddingParameterBeanAndPropertyNodes, Object[]> {
            public boolean isValid(Object[] value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addPropertyNode("myNode1").inIterable().atIndex(Integer.valueOf(23)).addBeanNode().addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface PropertyLevelValidationAddingBeanAndPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<PropertyLevelValidationAddingBeanAndPropertyNodes, Address> {
            public boolean isValid(Address value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode1").addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode2").inIterable().addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode3").inIterable().atIndex(Integer.valueOf(84)).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode4").inIterable().atKey((Object)"AnotherKey").addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().atIndex(Integer.valueOf(42)).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().atKey((Object)"Key").addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface ClassLevelValidationAddingPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ClassLevelValidationAddingPropertyNodes, Foo> {
            public boolean isValid(Foo value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode1").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode2").addPropertyNode("myNode3").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode4").addPropertyNode("myNode5").inIterable().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode6").addPropertyNode("myNode7").inIterable().atIndex(Integer.valueOf(42)).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode8").addPropertyNode("myNode9").inIterable().atKey((Object)"Foo").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode10").addPropertyNode("myNode11").inIterable().addPropertyNode("myNode12").addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface MyClassLevelValidation {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<MyClassLevelValidation, MyObject> {
            public boolean isValid(MyObject value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addNode("myNode1").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addNode("myNode2").addNode("myNode3").inIterable().atKey((Object)"key").addConstraintViolation();
                return false;
            }
        }
    }

    private static class ContainerElementNodeBean {
        @PropertyLevelValidationAddingContainerElementNodes
        private String property;

        private ContainerElementNodeBean() {
        }
    }

    private static class InContainerBean {
        @PropertyLevelValidationAddingInContainerPropertyNodes
        private String property;

        private InContainerBean() {
        }
    }

    private static class Country {
        private Country() {
        }

        public String getName() {
            return null;
        }
    }

    private static class Address {
        private Address() {
        }

        public String getStreet() {
            return null;
        }

        public Country getCountry() {
            return null;
        }
    }

    private static class User {
        private User() {
        }

        @PropertyLevelValidationAddingBeanAndPropertyNodes
        public Address getAddress() {
            return null;
        }

        @CrossParameterValidationAddingParameterBeanAndPropertyNodes
        public void setAddresses(Map<String, Address> addresses) {
        }
    }

    private static class Bar {
        @FieldLevelValidationAddingParameterNode
        private String bar;

        private Bar() {
        }
    }

    private static class FooContainer {
        @Valid
        private final List<Foo> fooList = Arrays.asList(null, new Foo());
        @Valid
        private final Foo[] fooArray = new Foo[]{null, new Foo()};
        @Valid
        private final Set<Foo> fooSet = TestUtil.asSet(null, new Foo());
        @Valid
        private final Map<String, Foo> fooMap = new HashMap<String, Foo>();

        public FooContainer() {
            this.fooMap.put("MapKey", new Foo());
        }
    }

    @ClassLevelValidationAddingPropertyNodes
    private static class Foo {
        private Foo() {
        }
    }

    @MyClassLevelValidation
    private static class MyObject {
        @NotNull
        String field1;
        @NotNull
        String field2;

        private MyObject() {
        }
    }
}

