/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.definition;

import jakarta.validation.Validation;
import jakarta.validation.valueextraction.ValueExtractor;
import jakarta.validation.valueextraction.ValueExtractorDefinitionException;
import java.util.List;
import java.util.Map;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.Container;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class InvalidValueExtractorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)InvalidValueExtractorTest.webArchiveBuilder().withTestClass(InvalidValueExtractorTest.class)).withPackage(Container.class.getPackage())).build();
    }

    @Test(expectedExceptions={ValueExtractorDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition-extractedvalue", id="b"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="f"), @SpecAssertion(section="valueextractordefinition-examples", id="a"), @SpecAssertion(section="exception-valueextractordefinition", id="a")})
    public void severalExtractedValuesThrowException() {
        Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new SeveralExtractedValuesValueExtractor()).buildValidatorFactory().getValidator();
    }

    @Test(expectedExceptions={ValueExtractorDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition-extractedvalue", id="b"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="f"), @SpecAssertion(section="exception-valueextractordefinition", id="a")})
    public void noExtractedValueThrowsException() {
        Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new NoExtractedValueValueExtractor()).buildValidatorFactory().getValidator();
    }

    private class NoExtractedValueValueExtractor
    implements ValueExtractor<List<?>> {
        private NoExtractedValueValueExtractor() {
        }

        public void extractValues(List<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            throw new IllegalStateException("May not be called");
        }
    }

    private class SeveralExtractedValuesValueExtractor
    implements ValueExtractor<Map<?, ?>> {
        private SeveralExtractedValuesValueExtractor() {
        }

        public void extractValues(Map<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            throw new IllegalStateException("May not be called");
        }
    }
}

