/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.groups.Default;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.NotEmpty;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ValidateWithGroupsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValidateWithGroupsTest.webArchiveBuilder().withTestClass(ValidateWithGroupsTest.class)).withClasses(Address.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidate() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new Address(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("street"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class, Address.Minimal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("street"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("zipCode"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidateProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"));
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Default.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"));
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = validator.validateProperty((Object)new Address(), "street", new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("street"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", null, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"));
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Default.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("city"));
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = validator.validateValue(Address.class, "street", null, new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("street"));
    }
}

