/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.traversableresolver;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Call;
import org.testng.Assert;

public class SnifferTraversableResolver
implements TraversableResolver {
    private int isReachableCallCount = 0;
    private int isCascadableCallCount = 0;
    private final Set<Call> expectedReachCalls = new HashSet<Call>();
    private final Set<Call> expectedCascadeCalls = new HashSet<Call>();
    private final Set<Call> executedReachableCalls = new HashSet<Call>();

    public SnifferTraversableResolver(Set<Call> expectedReachCalls, Set<Call> expectedCascadeCalls) {
        this.expectedReachCalls.addAll(expectedReachCalls);
        this.expectedCascadeCalls.addAll(expectedCascadeCalls);
    }

    public int getReachableCallCount() {
        return this.isReachableCallCount;
    }

    public int getCascadableCallCount() {
        return this.isCascadableCallCount;
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        List<String> names = this.extractNodeName(pathToTraversableObject);
        Call call = new Call(traversableObject, traversableProperty.getName(), rootBeanType, elementType, names.toArray(new String[names.size()]));
        this.executedReachableCalls.add(call);
        ++this.isReachableCallCount;
        return this.assertIsExpectedCall(this.expectedReachCalls, call);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        List<String> names = this.extractNodeName(pathToTraversableObject);
        Call call = new Call(traversableObject, traversableProperty.getName(), rootBeanType, elementType, names.toArray(new String[names.size()]));
        if (!this.executedReachableCalls.contains(call)) {
            throw new IllegalStateException("isCascadable called before a matching  isReachable call: " + call.toString());
        }
        ++this.isCascadableCallCount;
        return this.assertIsExpectedCall(this.expectedCascadeCalls, call);
    }

    private boolean assertIsExpectedCall(Set<Call> calls, Call call) {
        if (!calls.contains(call)) {
            Assert.fail((String)("Unexpected call to " + call.toString()));
        }
        return true;
    }

    private List<String> extractNodeName(Path path) {
        LinkedList<String> names = new LinkedList<String>();
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            names.add(((Path.Node)iter.next()).getName());
        }
        return names;
    }
}

