/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.traversableresolver;

import java.lang.annotation.ElementType;
import java.util.Arrays;

final class Call {
    private final Object traversableObject;
    private final String traversableProperty;
    private final Class<?> rootBeanType;
    private final String[] nodeNamesToTraversableObject;
    private final ElementType elementType;

    Call(Object traversableObject, String traversableProperty, Class<?> rootBeanType, ElementType elementType, String[] nodeNamesToTraversableObject) {
        this.traversableObject = traversableObject;
        this.traversableProperty = traversableProperty;
        this.rootBeanType = rootBeanType;
        this.nodeNamesToTraversableObject = nodeNamesToTraversableObject;
        this.elementType = elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call call = (Call)o;
        if (this.elementType != call.elementType) {
            return false;
        }
        if (!Arrays.equals(this.nodeNamesToTraversableObject, call.nodeNamesToTraversableObject)) {
            return false;
        }
        if (this.rootBeanType != null ? !this.rootBeanType.equals(call.rootBeanType) : call.rootBeanType != null) {
            return false;
        }
        if (this.traversableObject != null ? !this.traversableObject.equals(call.traversableObject) : call.traversableObject != null) {
            return false;
        }
        return !(this.traversableProperty != null ? !this.traversableProperty.equals(call.traversableProperty) : call.traversableProperty != null);
    }

    public int hashCode() {
        int result = this.traversableObject != null ? this.traversableObject.hashCode() : 0;
        result = 31 * result + (this.traversableProperty != null ? this.traversableProperty.hashCode() : 0);
        result = 31 * result + (this.rootBeanType != null ? this.rootBeanType.hashCode() : 0);
        result = 31 * result + (this.nodeNamesToTraversableObject != null ? Arrays.hashCode(this.nodeNamesToTraversableObject) : 0);
        result = 31 * result + (this.elementType != null ? this.elementType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Call");
        sb.append("{traversableObject=").append(this.traversableObject);
        sb.append(", traversableProperty='").append(this.traversableProperty).append('\'');
        sb.append(", rootBeanType=").append(this.rootBeanType);
        sb.append(", nodeNamesToTraversableObject=").append(this.nodeNamesToTraversableObject == null ? "null" : Arrays.asList(this.nodeNamesToTraversableObject).toString());
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append('}');
        return sb.toString();
    }
}

