/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent;

import jakarta.enterprise.inject.Instance;
import java.util.ArrayList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Bar;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Baz;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Foo;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Qux;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.TransactionalInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class DestroyingDependentInstanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DestroyingDependentInstanceTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="n")})
    public void testDestroyingDependentInstances(Instance<Foo> instance) {
        Assert.assertNotNull(instance);
        ArrayList<Foo> foos = new ArrayList<Foo>();
        ArrayList<Qux> quxs = new ArrayList<Qux>();
        for (int i = 0; i < 10; ++i) {
            Foo foo = (Foo)instance.get();
            foo.ping();
            foos.add(foo);
            quxs.add(foo.getQux());
        }
        Foo.reset();
        Qux.reset();
        Baz.reset();
        for (Foo component : foos) {
            instance.destroy((Object)component);
        }
        Assert.assertEquals(Foo.getDestroyedComponents(), foos);
        Assert.assertEquals(Qux.getDestroyedComponents(), quxs);
        Assert.assertFalse((boolean)Baz.isDestroyed());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="n")})
    public void testDestroyingInterceptedDependentBean(Instance<Bar> instance) {
        Assert.assertNotNull(instance);
        Bar bar = (Bar)instance.get();
        bar.ping();
        Bar.reset();
        TransactionalInterceptor.reset();
        instance.destroy((Object)bar);
        Assert.assertTrue((boolean)Bar.isDestroyed());
        Assert.assertTrue((boolean)TransactionalInterceptor.isDestroyed());
    }
}

