/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.beanContainer.bytype;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.beanContainer.bytype.AlternativeConnector;
import org.jboss.cdi.tck.tests.beanContainer.bytype.Connector;
import org.jboss.cdi.tck.tests.beanContainer.bytype.NonBindingTypeLiteral;
import org.jboss.cdi.tck.tests.beanContainer.bytype.SimpleBean;
import org.jboss.cdi.tck.tests.beanContainer.bytype.TameLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class BeanByTypeTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanByTypeTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="aa"), @SpecAssertion(section="bm_obtain_bean_by_type", id="b")})
    public void testGetBeans() {
        Set beans = this.getCurrentBeanContainer().getBeans(SimpleBean.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertEquals((Object)((Bean)beans.iterator().next()).getBeanClass(), SimpleBean.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="c")})
    public void testNoBindingImpliesCurrent() {
        Set beans = this.getCurrentBeanContainer().getBeans(SimpleBean.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertTrue((boolean)((Bean)beans.iterator().next()).getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="ab")})
    public void testGetBeansDoesNotResolveAlternatives() {
        Set beans = this.getCurrentBeanContainer().getBeans(Connector.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)2);
        for (Bean bean : beans) {
            if (this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Connector.class}) || this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Connector.class, AlternativeConnector.class})) continue;
            Assert.fail((String)"Unexpected bean types found");
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="da")})
    public <T> void testTypeVariable() {
        TypeVariable t = (TypeVariable)new TypeLiteral<T>(){}.getType();
        this.getCurrentBeanContainer().getBeans((Type)t, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="e")})
    public void testSameBindingTwice() {
        this.getCurrentBeanContainer().getBeans(SimpleBean.class, new Annotation[]{new TameLiteral("a"), new TameLiteral("b")});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_bean_by_type", id="f")})
    public void testNonBindingType() {
        this.getCurrentBeanContainer().getBeans(SimpleBean.class, new Annotation[]{new NonBindingTypeLiteral()});
    }
}

