/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.signaturetest;

import com.sun.ts.tests.el.signaturetest.SigTestResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class SignatureTestDriver {
    private static final System.Logger logger = System.getLogger(SignatureTestDriver.class.getName());
    private static final String SIG_FILE_EXT = ".sig";
    private static final String SIG_FILE_VER_SEP = "_";

    public SigTestResult executeSigTest(String packageListFile, String mapFile, String signatureRepositoryDir, String[] packagesUnderTest, String[] classesUnderTest, String classpath) throws Exception {
        String[] args2;
        String[] args;
        int i;
        SigTestResult result = new SigTestResult();
        if (packagesUnderTest != null && packagesUnderTest.length > 0) {
            logger.log(System.Logger.Level.INFO, "********** BEGIN PACKAGE LEVEL SIGNATURE VALIDATION **********\n\n");
            for (i = 0; i < packagesUnderTest.length; ++i) {
                String packageName = packagesUnderTest[i];
                logger.log(System.Logger.Level.INFO, "********** BEGIN VALIDATE PACKAGE '" + packagesUnderTest[i] + "' **********\n");
                logger.log(System.Logger.Level.INFO, "********** VALIDATE IN STATIC MODE - TO CHECK CONSANT VALUES ****");
                logger.log(System.Logger.Level.INFO, "Static mode supports checks of static constants values ");
                args = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packageName, classpath, true);
                SignatureTestDriver.dumpTestArguments(args);
                if (this.runSignatureTest(packageName, args)) {
                    logger.log(System.Logger.Level.INFO, "********** Package '" + packageName + "' - PASSED (STATIC MODE) **********");
                    result.addPassedPkg(packageName + "(static mode)");
                } else {
                    result.addFailedPkg(packageName + "(static mode)");
                    logger.log(System.Logger.Level.INFO, "********** Package '" + packageName + "' - FAILED (STATIC MODE) **********");
                }
                logger.log(System.Logger.Level.INFO, "\n\n");
                logger.log(System.Logger.Level.INFO, "********** VALIDATE IN REFLECTIVE MODE  ****");
                logger.log(System.Logger.Level.INFO, "Reflective mode supports verification within containers (ie ejb, servlet, etc)");
                args2 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packageName, classpath, false);
                SignatureTestDriver.dumpTestArguments(args2);
                if (this.runSignatureTest(packageName, args2)) {
                    logger.log(System.Logger.Level.INFO, "********** Package '" + packageName + "' - PASSED (REFLECTION MODE) **********");
                    result.addPassedPkg(packageName + "(reflection mode)");
                } else {
                    result.addFailedPkg(packageName + "(reflection mode)");
                    logger.log(System.Logger.Level.INFO, "********** Package '" + packageName + "' - FAILED (REFLECTION MODE) **********");
                }
                logger.log(System.Logger.Level.INFO, "********** END VALIDATE PACKAGE '" + packagesUnderTest[i] + "' **********\n");
                logger.log(System.Logger.Level.INFO, "\n");
                logger.log(System.Logger.Level.INFO, "\n");
            }
        }
        if (classesUnderTest != null && classesUnderTest.length > 0) {
            logger.log(System.Logger.Level.INFO, "********** BEGIN CLASS LEVEL SIGNATURE VALIDATION **********\n\n");
            for (i = 0; i < classesUnderTest.length; ++i) {
                String className = classesUnderTest[i];
                logger.log(System.Logger.Level.INFO, "********** BEGIN VALIDATE CLASS '" + classesUnderTest[i] + "' **********\n");
                logger.log(System.Logger.Level.INFO, "********** VALIDATE IN STATIC MODE - TO CHECK CONSANT VALUES ****");
                logger.log(System.Logger.Level.INFO, "Static mode supports checks of static constants values ");
                args = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, className, classpath, true);
                SignatureTestDriver.dumpTestArguments(args);
                if (this.runSignatureTest(className, args)) {
                    logger.log(System.Logger.Level.INFO, "********** Class '" + className + "' - PASSED (STATIC MODE) **********");
                    result.addPassedClass(className + "(static mode)");
                } else {
                    logger.log(System.Logger.Level.INFO, "********** Class '" + className + "' - FAILED (STATIC MODE) **********");
                    result.addFailedClass(className + "(static mode)");
                }
                logger.log(System.Logger.Level.INFO, "\n\n");
                logger.log(System.Logger.Level.INFO, "********** VALIDATE IN REFLECTIVE MODE  ****");
                logger.log(System.Logger.Level.INFO, "Reflective mode supports verification within containers (ie ejb, servlet, etc)");
                args2 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, className, classpath, false);
                SignatureTestDriver.dumpTestArguments(args2);
                if (this.runSignatureTest(className, args2)) {
                    logger.log(System.Logger.Level.INFO, "********** Class '" + className + "' - PASSED (REFLECTION MODE) **********");
                    result.addPassedClass(className + "(reflection mode)");
                } else {
                    logger.log(System.Logger.Level.INFO, "********** Class '" + className + "' - FAILED (REFLECTION MODE) **********");
                    result.addFailedClass(className + "(reflection mode)");
                }
                logger.log(System.Logger.Level.INFO, "********** END VALIDATE CLASS '" + classesUnderTest[i] + "' **********\n");
                logger.log(System.Logger.Level.INFO, "\n");
                logger.log(System.Logger.Level.INFO, "\n");
            }
        }
        return result;
    }

    protected abstract String[] createTestArguments(String var1, String var2, String var3, String var4, String var5, boolean var6) throws Exception;

    protected abstract boolean runSignatureTest(String var1, String[] var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadMapFile(String mapFile) throws IOException, FileNotFoundException {
        FileInputStream in = null;
        try {
            File map = new File(mapFile);
            Properties props = new Properties();
            in = new FileInputStream(map);
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected String getSigFileName(String baseName, String repositoryDir, String version) throws FileNotFoundException {
        String sigFile = repositoryDir.endsWith(File.separator) ? repositoryDir + baseName + ".sig_" + version : repositoryDir + File.separator + baseName + ".sig_" + version;
        File testFile = new File(sigFile);
        if (!testFile.exists() && !testFile.isFile()) {
            throw new FileNotFoundException("Signature file \"" + sigFile + "\" does not exist.");
        }
        return testFile.toString();
    }

    protected SignatureFileInfo getSigFileInfo(String packageName, String mapFile, String repositoryDir) throws Exception {
        String originalPackage = packageName;
        String name = null;
        String version = null;
        Properties props = this.loadMapFile(mapFile);
        while (true) {
            boolean packageFound = false;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.equals(packageName)) continue;
                version = props.getProperty(name);
                packageFound = true;
                break;
            }
            if (packageFound) break;
            int index = packageName.lastIndexOf(".");
            if (index <= 0) {
                throw new Exception("Package \"" + originalPackage + "\" not specified in mapping file \"" + mapFile + "\".");
            }
            packageName = packageName.substring(0, index);
        }
        return new SignatureFileInfo(this.getSigFileName(name, repositoryDir, version), version);
    }

    private static void dumpTestArguments(String[] params) {
        if (params != null && params.length > 0) {
            logger.log(System.Logger.Level.TRACE, "----------------- BEGIN SIG PARAM DUMP -----------------");
            for (int i = 0; i < params.length; ++i) {
                logger.log(System.Logger.Level.TRACE, "   Param[" + i + "]: " + params[i]);
            }
            logger.log(System.Logger.Level.TRACE, "------------------ END SIG PARAM DUMP ------------------");
        }
    }

    protected static class SignatureFileInfo {
        private String file;
        private String version;

        public SignatureFileInfo(String file, String version) {
            if (file == null) {
                throw new IllegalArgumentException("'file' argument cannot be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("'version' argument cannot be null");
            }
            this.file = file;
            this.version = version;
        }

        public String getFile() {
            return this.file;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

