/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextUtil;
import com.sun.enterprise.module.bootstrap.StartupContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="__locations")
@Singleton
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="locations.command")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="locations", description="Location", useForAuthorization=true)})
public class LocationsCommand
implements AdminCommand {
    @Inject
    ServerEnvironmentImpl serverEnvironment;
    @Inject
    private UnprocessedConfigListener ucl;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(this.serverEnvironment.getInstanceRoot().getAbsolutePath().replace('\\', '/'));
        ActionReport.MessagePart messagePart = report.getTopMessagePart();
        messagePart.addProperty("Base-Root", StartupContextUtil.getInstallRoot((StartupContext)this.serverEnvironment.getStartupContext()).getAbsolutePath());
        messagePart.addProperty("Domain-Root", this.serverEnvironment.getInstanceRoot().getAbsolutePath());
        messagePart.addProperty("Instance-Root", this.serverEnvironment.getInstanceRoot().getAbsolutePath());
        messagePart.addProperty("Config-Dir", this.serverEnvironment.getConfigDirPath().getAbsolutePath());
        messagePart.addProperty("Uptime", "" + this.getUptime());
        messagePart.addProperty("Pid", Long.toString(ProcessHandle.current().pid()));
        messagePart.addProperty("Restart-Required", "" + this.ucl.serverRequiresRestart());
    }

    private long getUptime() {
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        long totalTime_ms = -1L;
        if (mxbean != null) {
            totalTime_ms = mxbean.getUptime();
        }
        if (totalTime_ms <= 0L) {
            long start = this.serverEnvironment.getStartupContext().getCreationTime();
            totalTime_ms = System.currentTimeMillis() - start;
        }
        return totalTime_ms;
    }
}

