/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.LifecycleEventContextImpl;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.loader.util.ASClassLoaderUtil;

public final class ServerLifecycleModule {
    private static final Logger _logger = KernelLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerLifecycleModule.class);
    private LifecycleListener slcl;
    private final String name;
    private final String className;
    private String classpath;
    private int loadOrder;
    private boolean isFatal;
    private final String statusMsg = "OK";
    private final ServerContext ctx;
    private final LifecycleEventContext leContext;
    private ClassLoader urlClassLoader;
    private final Properties props = new Properties();

    ServerLifecycleModule(ServerContext ctx, String name, String className) {
        this.name = name;
        this.className = className;
        this.ctx = ctx;
        this.leContext = new LifecycleEventContextImpl(ctx);
    }

    void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    void setProperty(String name, String value) {
        this.props.put(name, value);
    }

    Properties getProperties() {
        return this.props;
    }

    void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    void setIsFatal(boolean isFatal) {
        this.isFatal = isFatal;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getClasspath() {
        return this.classpath;
    }

    int getLoadOrder() {
        return this.loadOrder;
    }

    boolean isFatal() {
        return this.isFatal;
    }

    LifecycleListener loadServerLifecycle() throws ServerLifecycleException {
        block4: {
            try {
                ClassLoader classLoader;
                if (this.classpath == null) {
                    classLoader = this.ctx.getLifecycleParentClassLoader();
                } else {
                    URL[] urls = this.getURLs();
                    _logger.log(Level.FINE, "Lifecycle module = {0} has classpath URLs = {1}", new Object[]{this.getName(), urls});
                    classLoader = this.urlClassLoader = new GlassfishUrlClassLoader(urls, this.ctx.getLifecycleParentClassLoader());
                }
                Class<?> clazz = Class.forName(this.className, true, classLoader);
                this.slcl = (LifecycleListener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ee) {
                LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"NCLS-CORE-00052", (Throwable)ee, (Object[])new Object[]{this.name, ee});
                if (!this.isFatal) break block4;
                throw new ServerLifecycleException(localStrings.getLocalString("lifecyclemodule.loadExceptionIsFatal", "Treating failure loading the lifecycle module as fatal", new Object[]{this.name}));
            }
        }
        return this.slcl;
    }

    private URL[] getURLs() {
        List urlList = ASClassLoaderUtil.getURLsFromClasspath((String)this.classpath, (String)File.pathSeparator, (String)"");
        return ASClassLoaderUtil.convertURLListToArray((List)urlList);
    }

    private void postEvent(int eventType, Object data) throws ServerLifecycleException {
        block7: {
            if (this.slcl == null) {
                if (this.isFatal) {
                    throw new ServerLifecycleException(localStrings.getLocalString("lifecyclemodule.loadExceptionIsFatal", "Treating failure loading the lifecycle module as fatal", new Object[]{this.name}));
                }
                return;
            }
            if (this.urlClassLoader != null) {
                this.setClassLoader();
            }
            LifecycleEvent slcEvent = new LifecycleEvent((Object)this, eventType, data, this.leContext);
            try {
                this.slcl.handleEvent(slcEvent);
            }
            catch (ServerLifecycleException sle) {
                LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"NCLS-CORE-00053", (Throwable)sle, (Object[])new Object[]{this.name, sle});
                if (this.isFatal) {
                    throw sle;
                }
            }
            catch (Exception ee) {
                LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"NCLS-CORE-00054", (Throwable)ee, (Object[])new Object[]{this.name, ee});
                if (!this.isFatal) break block7;
                throw new ServerLifecycleException(localStrings.getLocalString("lifecyclemodule.event_exceptionIsFatal", "Treating the exception from lifecycle module event handler as fatal"), (Throwable)ee);
            }
        }
    }

    public void onInitialization() throws ServerLifecycleException {
        this.postEvent(0, this.props);
    }

    public void onStartup() throws ServerLifecycleException {
        this.postEvent(1, this.props);
    }

    public void onReady() throws ServerLifecycleException {
        this.postEvent(2, this.props);
    }

    public void onShutdown() throws ServerLifecycleException {
        this.postEvent(3, this.props);
    }

    public void onTermination() throws ServerLifecycleException {
        this.postEvent(4, this.props);
    }

    private void setClassLoader() {
        PrivilegedAction<Void> action = () -> {
            Thread.currentThread().setContextClassLoader(this.urlClassLoader);
            return null;
        };
        AccessController.doPrivileged(action);
    }

    public String getStatus() {
        return "OK";
    }

    public String toString() {
        return "Server LifecycleListener support";
    }
}

