/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.v3.admin.JobManagerService;
import java.lang.annotation.Annotation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.internal.api.Globals;

public class DetachedCommandHelper
implements Runnable,
AdminCommandEventBroker.AdminCommandListener {
    private final CommandRunner.CommandInvocation commandInvocation;
    private CountDownLatch latch;
    private String jobId;
    private AdminCommandEventBroker broker;

    private DetachedCommandHelper(CommandRunner.CommandInvocation commandInvocation, CountDownLatch latch) {
        this.commandInvocation = commandInvocation;
        this.latch = latch;
    }

    @Override
    public void run() {
        this.commandInvocation.execute();
    }

    public static String invokeAsync(CommandRunner.CommandInvocation commandInvocation) {
        if (commandInvocation == null) {
            throw new IllegalArgumentException("commandInvocation");
        }
        CountDownLatch latch = new CountDownLatch(1);
        DetachedCommandHelper helper = new DetachedCommandHelper(commandInvocation, latch);
        commandInvocation.listener(".*", (AdminCommandEventBroker.AdminCommandListener)helper);
        JobManagerService jobManagerService = Globals.getDefaultHabitat().getService(JobManagerService.class, new Annotation[0]);
        jobManagerService.getThreadPool().execute(helper);
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                RestLogging.restLogger.log(Level.FINE, "latch.await() returned false");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return helper.jobId;
    }

    public void onAdminCommandEvent(String name, Object event) {
        if (name == null || event == null) {
            return;
        }
        if ("local/listener/register".equals(name)) {
            AdminCommandEventBroker.BrokerListenerRegEvent blre = (AdminCommandEventBroker.BrokerListenerRegEvent)event;
            this.broker = blre.getBroker();
            return;
        }
        if (name.startsWith("local/")) {
            return;
        }
        if ("AdminCommandInstance/stateChanged".equals(name)) {
            this.unregister();
            AdminCommandState acs = (AdminCommandState)event;
            this.jobId = acs.getId();
            this.latch.countDown();
        }
    }

    private void unregister() {
        if (this.broker != null) {
            this.broker.unregisterListener((AdminCommandEventBroker.AdminCommandListener)this);
        }
    }
}

