/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import java.lang.annotation.Annotation;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConcurrencyManagement.class)
public class ConcurrencyManagementHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        ConcurrencyManagement cmAn = (ConcurrencyManagement)ainfo.getAnnotation();
        ConcurrencyManagementType cmType = cmAn.value();
        for (EjbContext ejbContext : ejbContexts) {
            EjbSessionDescriptor.ConcurrencyManagementType descCMType;
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (!(ejbDesc instanceof EjbSessionDescriptor)) continue;
            switch (cmType) {
                case CONTAINER: {
                    descCMType = EjbSessionDescriptor.ConcurrencyManagementType.Container;
                    break;
                }
                case BEAN: {
                    descCMType = EjbSessionDescriptor.ConcurrencyManagementType.Bean;
                    break;
                }
                default: {
                    throw new AnnotationProcessorException("Unsupported concurrency management type = " + String.valueOf((Object)cmType));
                }
            }
            EjbSessionDescriptor sDesc = (EjbSessionDescriptor)ejbDesc;
            sDesc.setConcurrencyManagementTypeIfNotSet(descCMType);
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }
}

