/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.connector;

import com.sun.enterprise.config.serverbeans.Config;
import jakarta.decorator.Decorator;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Stereotype;
import jakarta.inject.Scope;
import jakarta.interceptor.Interceptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.weld.connector.CDIService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WeldUtils {
    private static Logger logger = Logger.getLogger(WeldUtils.class.getName());
    public static final char SEPARATOR_CHAR = '/';
    public static final String WEB_INF = "WEB-INF";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String BEANS_XML_FILENAME = "beans.xml";
    public static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_CLASSES_META_INF_BEANS_XML = "WEB-INF/classes/META-INF/beans.xml";
    private static final String SERVICES_DIR = "services";
    private static final String SERVICES_PORTABLE_CLASSNAME = "jakarta.enterprise.inject.spi.Extension";
    private static final String SERVICES_BUILD_CLASSNAME = "jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String META_INF_SERVICES_PORTABLE_EXTENSION = "META-INF/services/jakarta.enterprise.inject.spi.Extension";
    public static final String META_INF_SERVICES_BUILD_EXTENSION = "META-INF/services/jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String WEB_INF_SERVICES_PORTABLE_EXTENSION = "WEB-INF/classes/META-INF/services/jakarta.enterprise.inject.spi.Extension";
    public static final String WEB_INF_SERVICES_BUILD_EXTENSION = "WEB-INF/classes/META-INF/services/jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String CLASS_SUFFIX = ".class";
    public static final String JAR_SUFFIX = ".jar";
    public static final String RAR_SUFFIX = ".rar";
    public static final String EXPANDED_RAR_SUFFIX = "_rar";
    public static final String EXPANDED_JAR_SUFFIX = "_jar";
    public static final String IMPLICIT_CDI_ENABLED_PROP = "implicitCdiEnabled";
    private static final List<String> cdiScopeAnnotations = new ArrayList<String>();
    private static final List<String> cdiEnablingAnnotations;

    public static boolean isImplicitBeanArchive(DeploymentContext context, ReadableArchive archive) throws IOException {
        if (!WeldUtils.isValidBdaBasedOnExtensionAndBeansXml(archive)) {
            return false;
        }
        return WeldUtils.isImplicitBeanArchive(context, archive.getURI());
    }

    public static boolean isImplicitBeanArchive(DeploymentContext context, URI archivePath) {
        return WeldUtils.isImplicitBeanDiscoveryEnabled(context) && WeldUtils.hasCDIEnablingAnnotations(context, archivePath);
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, URI path) {
        return WeldUtils.hasCDIEnablingAnnotations(context, Set.of(path));
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, Collection<URI> paths) {
        ArrayList<String> result = new ArrayList<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel annotationModel : type.getAnnotations()) {
                    AnnotationType annotationType = annotationModel.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(annotationType) || !type.wasDefinedIn(paths) || result.contains(annotationType.getName())) continue;
                    result.add(annotationType.getName());
                }
            }
        }
        return !result.isEmpty();
    }

    public static String[] getCDIEnablingAnnotations(DeploymentContext context) {
        ArrayList<String> result = new ArrayList<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel annotationModel : type.getAnnotations()) {
                    AnnotationType annotationType = annotationModel.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(annotationType) || result.contains(annotationType.getName())) continue;
                    result.add(annotationType.getName());
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Collection<String> getCDIAnnotatedClassNames(DeploymentContext context) {
        HashSet<String> result = new HashSet<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel annotationModel : type.getAnnotations()) {
                    AnnotationType annotationType = annotationModel.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(annotationType) || result.contains(annotationType.getName())) continue;
                    result.add(type.getName());
                }
            }
        }
        return result;
    }

    public static boolean hasScopeAnnotation(Class<?> clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiScopeAnnotations, null);
    }

    public static boolean hasCDIEnablingAnnotation(Class<?> clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiEnablingAnnotations, null);
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType) {
        return WeldUtils.isCDIEnablingAnnotation(annotationType, null);
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType, Set<String> excludedTypeNames) {
        String annotationTypeName;
        HashSet<String> exclusions = new HashSet<String>();
        if (excludedTypeNames != null) {
            exclusions.addAll(excludedTypeNames);
        }
        if (cdiEnablingAnnotations.contains(annotationTypeName = annotationType.getName()) && !exclusions.contains(annotationTypeName)) {
            return true;
        }
        if (!exclusions.contains(annotationTypeName)) {
            exclusions.add(annotationTypeName);
            for (AnnotationModel parent : annotationType.getAnnotations()) {
                if (!WeldUtils.isCDIEnablingAnnotation(parent.getType(), exclusions)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasValidAnnotation(Class<?> annotatedClass, Collection<String> validScopes, Collection<String> excludedScopes) {
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            if (!WeldUtils.isValidAnnotation(annotation.annotationType(), validScopes, excludedScopes)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isValidAnnotation(Class<? extends Annotation> annotationType, Collection<String> validTypeNames, Collection<String> excludedTypeNames) {
        boolean result = false;
        if (validTypeNames != null && !validTypeNames.isEmpty()) {
            String annotationTypeName;
            HashSet<String> excludedScopes = new HashSet<String>();
            if (excludedTypeNames != null) {
                excludedScopes.addAll(excludedTypeNames);
            }
            if (validTypeNames.contains(annotationTypeName = annotationType.getName()) && !excludedScopes.contains(annotationTypeName)) {
                result = true;
            } else if (!excludedScopes.contains(annotationTypeName)) {
                excludedScopes.add(annotationTypeName);
                for (Annotation parent : annotationType.getAnnotations()) {
                    if (!WeldUtils.isValidAnnotation(parent.annotationType(), validTypeNames, excludedScopes)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private static Types getTypes(DeploymentContext context) {
        String metadataKey = Types.class.getName();
        Types types = (Types)context.getTransientAppMetadata().get(metadataKey);
        while (types == null && (context = ((ExtendedDeploymentContext)context).getParentContext()) != null) {
            types = (Types)context.getTransientAppMetadata().get(metadataKey);
        }
        return types;
    }

    public static boolean isImplicitBeanDiscoveryEnabled() {
        Config config;
        boolean result = false;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Boolean.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getEnableImplicitCdi());
        }
        return result;
    }

    public static boolean isImplicitBeanDiscoveryEnabled(DeploymentContext context) {
        if (!WeldUtils.isImplicitBeanDiscoveryEnabled()) {
            return false;
        }
        Object propValue = context.getAppProps().get(IMPLICIT_CDI_ENABLED_PROP);
        return propValue == null || Boolean.parseBoolean((String)propValue);
    }

    public static InputStream getBeansXmlInputStream(DeploymentContext context) {
        return WeldUtils.getBeansXmlInputStream(context.getSource());
    }

    public static boolean isValidBdaBasedOnExtensionAndBeansXml(ReadableArchive archive) {
        try {
            if (WeldUtils.hasExtension(archive) && !WeldUtils.hasBeansXMl(archive)) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean hasExtension(ReadableArchive archive) {
        try {
            if (WeldUtils.isWar(archive)) {
                return archive.exists(WEB_INF_SERVICES_PORTABLE_EXTENSION) || archive.exists(WEB_INF_SERVICES_BUILD_EXTENSION);
            }
            return archive.exists(META_INF_SERVICES_PORTABLE_EXTENSION) || archive.exists(META_INF_SERVICES_BUILD_EXTENSION);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            return false;
        }
    }

    public static boolean hasBeansXMl(ReadableArchive archive) throws IOException {
        if (WeldUtils.isWar(archive)) {
            return archive.exists(WEB_INF_BEANS_XML) || archive.exists(WEB_INF_CLASSES_META_INF_BEANS_XML);
        }
        return archive.exists(META_INF_BEANS_XML);
    }

    public static boolean isWar(ReadableArchive archive) throws IOException {
        return archive.exists(WEB_INF);
    }

    public static InputStream getBeansXmlInputStream(ReadableArchive archive) {
        InputStream inputStream = null;
        try {
            if (archive.exists(WEB_INF)) {
                inputStream = archive.getEntry(WEB_INF_BEANS_XML);
                if (inputStream == null) {
                    inputStream = archive.getEntry(WEB_INF_CLASSES_META_INF_BEANS_XML);
                }
            } else {
                inputStream = archive.getEntry(META_INF_BEANS_XML);
            }
        }
        catch (IOException e) {
            return null;
        }
        return inputStream;
    }

    public static String getBeanDiscoveryMode(InputStream beansXmlInputStream) {
        if (beansXmlInputStream == null) {
            return "annotated";
        }
        String beanDiscoveryMode = null;
        LocalDefaultHandler handler = new LocalDefaultHandler();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(beansXmlInputStream, (DefaultHandler)handler);
        }
        catch (SAXStoppedIntentionallyException exc) {
            beanDiscoveryMode = handler.getBeanDiscoveryMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanDiscoveryMode == null) {
            return "annotated";
        }
        if (beanDiscoveryMode.equals("")) {
            return "annotated";
        }
        return beanDiscoveryMode;
    }

    static {
        cdiScopeAnnotations.add(Scope.class.getName());
        cdiScopeAnnotations.add(NormalScope.class.getName());
        cdiScopeAnnotations.add(ApplicationScoped.class.getName());
        cdiScopeAnnotations.add(SessionScoped.class.getName());
        cdiScopeAnnotations.add(RequestScoped.class.getName());
        cdiScopeAnnotations.add(Dependent.class.getName());
        cdiScopeAnnotations.add(jakarta.inject.Singleton.class.getName());
        cdiEnablingAnnotations = new ArrayList<String>();
        cdiEnablingAnnotations.addAll(cdiScopeAnnotations);
        cdiEnablingAnnotations.add(Decorator.class.getName());
        cdiEnablingAnnotations.add(Interceptor.class.getName());
        cdiEnablingAnnotations.add(Stereotype.class.getName());
        cdiEnablingAnnotations.add(MessageDriven.class.getName());
        cdiEnablingAnnotations.add(Stateful.class.getName());
        cdiEnablingAnnotations.add(Stateless.class.getName());
        cdiEnablingAnnotations.add(Singleton.class.getName());
    }

    private static class LocalDefaultHandler
    extends DefaultHandler {
        String beanDiscoveryMode = null;

        private LocalDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("beans")) {
                this.beanDiscoveryMode = attributes.getValue("bean-discovery-mode");
                throw new SAXStoppedIntentionallyException();
            }
        }

        public String getBeanDiscoveryMode() {
            return this.beanDiscoveryMode;
        }
    }

    private static class SAXStoppedIntentionallyException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        private SAXStoppedIntentionallyException() {
        }
    }

    public static enum BDAType {
        WAR,
        JAR,
        RAR,
        UNKNOWN;

    }
}

