/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.KeyConstraintObjectDefinition;

public class ForeignKeyConstraint
extends KeyConstraintObjectDefinition {
    protected List<String> targetFields = new ArrayList<String>();
    protected String targetTable;
    protected boolean shouldCascadeOnDelete;
    protected String foreignKeyDefinition;
    protected boolean disableForeignKey;

    public ForeignKeyConstraint() {
        this.targetTable = "";
        this.shouldCascadeOnDelete = false;
    }

    public ForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        super(name, sourceField);
        this.targetFields.add(targetField);
        this.targetTable = targetTable;
    }

    public void addTargetField(String targetField) {
        this.getTargetFields().add(targetField);
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            if (this.hasForeignKeyDefinition()) {
                writer.write(this.getForeignKeyDefinition());
            } else {
                writer.write("FOREIGN KEY ");
                this.appendKeys(writer, this.getSourceFields());
                writer.write(" REFERENCES ");
                writer.write(this.getTargetTable());
                writer.write(" ");
                this.appendKeys(writer, this.getTargetFields());
                if (this.shouldCascadeOnDelete() && session.getPlatform().supportsDeleteOnCascade()) {
                    writer.write(" ON DELETE CASCADE");
                }
                super.appendDBString(writer, session);
            }
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof IOException) {
                throw ValidationException.fileError((IOException)ex.getCause());
            }
            throw ValidationException.fileError(new IOException(ex.getCause()));
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void cascadeOnDelete() {
        this.setShouldCascadeOnDelete(true);
    }

    public boolean disableForeignKey() {
        return this.disableForeignKey;
    }

    public void dontCascadeOnDelete() {
        this.setShouldCascadeOnDelete(false);
    }

    public String getForeignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public List<String> getTargetFields() {
        return this.targetFields;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public boolean hasForeignKeyDefinition() {
        return this.foreignKeyDefinition != null;
    }

    public boolean isDisableForeignKey() {
        return this.disableForeignKey;
    }

    public void setDisableForeignKey(boolean disableForeignKey) {
        this.disableForeignKey = disableForeignKey;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.foreignKeyDefinition = foreignKeyDefinition;
    }

    public void setShouldCascadeOnDelete(boolean shouldCascadeOnDelete) {
        this.shouldCascadeOnDelete = shouldCascadeOnDelete;
    }

    public void setTargetFields(List<String> targetFields) {
        this.targetFields = targetFields;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public boolean shouldCascadeOnDelete() {
        return this.shouldCascadeOnDelete;
    }
}

