/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

public class UserError
extends Throwable {
    private static final long serialVersionUID = 4171944609382558583L;
    private static final String SHOW_STACK_TRACES_PROPERTY_NAME = UserError.class.getPackage().getName() + ".showUserErrorStackTraces";
    private String usage;

    public static UserError formatUserError(String message, String ... args) {
        String formattedMessage = MessageFormat.format(message, args);
        UserError ue = new UserError(formattedMessage);
        return ue;
    }

    public UserError(String message) {
        super(message);
    }

    public UserError(String message, Throwable cause) {
        super(message, cause);
    }

    public UserError(Throwable cause) {
        super(cause);
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void displayAndExit() {
        this.display(System.err);
        System.exit(1);
    }

    private void display(PrintStream ps) {
        for (Throwable t = this; t != null; t = t.getCause()) {
            ps.println(t.toString());
        }
        if (this.usage != null) {
            ps.println(this.usage);
        }
        if (Boolean.getBoolean(SHOW_STACK_TRACES_PROPERTY_NAME)) {
            this.printStackTrace(ps);
        }
    }

    public String messageForGUIDisplay() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.display(ps);
        return os.toString();
    }
}

