/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.model.ResourceItem;
import java.io.File;
import java.io.Serializable;

public final class FileChooserItem
implements ResourceItem,
Serializable {
    private static final long serialVersionUID = -6760386335678324488L;
    private File item = null;
    private String itemKey = null;
    private String itemLabel = null;
    private boolean itemDisabled = true;

    public FileChooserItem(File file) {
        this.item = file;
        StringBuilder buffer = new StringBuilder();
        if (this.item.isDirectory()) {
            buffer.append("folder=");
        } else {
            buffer.append("file=");
        }
        buffer.append(this.item.getAbsolutePath());
        this.itemKey = buffer.toString();
    }

    @Override
    public Object getItemValue() {
        return this.item;
    }

    @Override
    public String getItemKey() {
        return this.itemKey;
    }

    @Override
    public void setItemKey(String key) {
        if (key != null) {
            this.itemKey = key;
        }
    }

    @Override
    public String getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(String label) {
        if (label != null) {
            this.itemLabel = label;
        }
    }

    @Override
    public boolean isItemDisabled() {
        return this.itemDisabled;
    }

    @Override
    public void setItemDisabled(boolean disabled) {
        this.itemDisabled = disabled;
    }

    @Override
    public boolean isContainerItem() {
        return this.item.isDirectory();
    }

    @Override
    public boolean equals(Object object) {
        boolean flags;
        if (!(object instanceof ResourceItem)) {
            return false;
        }
        ResourceItem resourceItem = (ResourceItem)object;
        boolean bl = flags = this.isContainerItem() == resourceItem.isContainerItem() && this.isItemDisabled() == resourceItem.isItemDisabled();
        if (!flags) {
            return false;
        }
        if (!FileChooserItem.objectEquals(this.getItemValue(), resourceItem.getItemValue())) {
            return false;
        }
        if (!FileChooserItem.objectEquals(this.getItemKey(), resourceItem.getItemKey())) {
            return false;
        }
        return FileChooserItem.objectEquals(this.getItemLabel(), resourceItem.getItemLabel());
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash;
        if (this.item != null) {
            hash += this.item.hashCode();
        }
        hash = 79 * hash;
        if (this.itemKey != null) {
            hash += this.itemKey.hashCode();
        }
        hash = 79 * hash;
        if (this.itemLabel != null) {
            hash += this.itemLabel.hashCode();
        }
        hash = 79 * hash;
        if (this.itemDisabled) {
            ++hash;
        }
        return hash;
    }

    private static boolean objectEquals(Object obj0, Object obj1) {
        if (obj0 == null) {
            return obj1 == null;
        }
        return !obj0.equals(obj1);
    }
}

