/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Extension;
import jakarta.websocket.SendHandler;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.core.frame.TyrusFrame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.WriterInfo;

public class TyrusWebSocket {
    private final TyrusEndpointWrapper endpointWrapper;
    private final ProtocolHandler protocolHandler;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final Lock lock = new ReentrantLock();
    private volatile MessageEventListener messageEventListener = MessageEventListener.NO_OP;
    private static final WriterInfo PING_INFO = new WriterInfo(WriterInfo.MessageType.PING, WriterInfo.RemoteEndpointType.SUPER);
    private static final WriterInfo PONG_INFO = new WriterInfo(WriterInfo.MessageType.PONG, WriterInfo.RemoteEndpointType.SUPER);

    public TyrusWebSocket(ProtocolHandler protocolHandler, TyrusEndpointWrapper endpointWrapper) {
        this.protocolHandler = protocolHandler;
        this.endpointWrapper = endpointWrapper;
        protocolHandler.setWebSocket(this);
    }

    public void setWriteTimeout(long timeoutMs) {
    }

    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(CloseFrame frame) {
        boolean locked = this.lock.tryLock();
        if (locked) {
            try {
                CloseReason closeReason = frame.getCloseReason();
                if (this.endpointWrapper != null) {
                    this.endpointWrapper.onClose(this, closeReason);
                }
                if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
                    this.protocolHandler.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
                } else {
                    this.state.set(State.CLOSED);
                    this.protocolHandler.doClose();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void onConnect(UpgradeRequest upgradeRequest, String subProtocol, List<Extension> extensions, String connectionId, DebugContext debugContext) {
        this.state.set(State.CONNECTED);
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onConnect(this, upgradeRequest, subProtocol, extensions, connectionId, debugContext);
        }
        this.onConnectLatch.countDown();
    }

    public void onFragment(BinaryFrame frame, boolean last) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onPartialMessage(this, ByteBuffer.wrap(frame.getPayloadData()), last);
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void onFragment(TextFrame frame, boolean last) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onPartialMessage(this, frame.getTextPayload(), last);
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void onMessage(BinaryFrame frame) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onMessage(this, ByteBuffer.wrap(frame.getPayloadData()));
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void onMessage(TextFrame frame) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onMessage(this, frame.getTextPayload());
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void onPing(PingFrame frame) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onPing(this, ByteBuffer.wrap(frame.getPayloadData()));
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void onPong(PongFrame frame) {
        this.awaitOnConnect();
        if (this.endpointWrapper != null) {
            this.endpointWrapper.onPong(this, ByteBuffer.wrap(frame.getPayloadData()));
            this.messageEventListener.onFrameReceived(frame.getFrameType(), frame.getPayloadLength());
        }
    }

    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), null);
    }

    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    public void close(CloseReason closeReason) {
        this.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    @Deprecated
    public Future<Frame> sendBinary(byte[] data) {
        this.checkConnectedState();
        return this.protocolHandler.send(data);
    }

    public Future<Frame> sendBinary(byte[] data, WriterInfo writerInfo) {
        this.checkConnectedState();
        return this.protocolHandler.send(data, writerInfo);
    }

    @Deprecated
    public void sendBinary(byte[] data, SendHandler handler) {
        this.checkConnectedState();
        this.protocolHandler.send(data, handler);
    }

    public void sendBinary(byte[] data, SendHandler handler, WriterInfo writerInfo) {
        this.checkConnectedState();
        this.protocolHandler.send(data, handler, writerInfo);
    }

    @Deprecated
    public Future<Frame> sendText(String data) {
        this.checkConnectedState();
        return this.protocolHandler.send(data);
    }

    public Future<Frame> sendText(String data, WriterInfo writerInfo) {
        this.checkConnectedState();
        return this.protocolHandler.send(data, writerInfo);
    }

    @Deprecated
    public void sendText(String data, SendHandler handler) {
        this.checkConnectedState();
        this.protocolHandler.send(data, handler);
    }

    public void sendText(String data, SendHandler handler, WriterInfo writerInfo) {
        this.checkConnectedState();
        this.protocolHandler.send(data, handler, writerInfo);
    }

    public Future<Frame> sendRawFrame(ByteBuffer data) {
        this.checkConnectedState();
        return this.protocolHandler.sendRawFrame(data);
    }

    public Future<Frame> sendPing(byte[] data) {
        return this.send(new PingFrame(data), PING_INFO);
    }

    public Future<Frame> sendPong(byte[] data) {
        return this.send(new PongFrame(data), PONG_INFO);
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<Frame> send(TyrusFrame frame, WriterInfo writerInfo) {
        this.checkConnectedState();
        return this.protocolHandler.send(frame, writerInfo);
    }

    @Deprecated
    public Future<Frame> sendText(String fragment, boolean last) {
        this.checkConnectedState();
        return this.protocolHandler.stream(last, fragment);
    }

    public Future<Frame> sendText(String fragment, boolean last, WriterInfo writerInfo) {
        this.checkConnectedState();
        return this.protocolHandler.stream(last, fragment, writerInfo);
    }

    @Deprecated
    public Future<Frame> sendBinary(byte[] bytes, boolean last) {
        return this.sendBinary(bytes, 0, bytes.length, last);
    }

    public Future<Frame> sendBinary(byte[] bytes, boolean last, WriterInfo writerInfo) {
        return this.sendBinary(bytes, 0, bytes.length, last, writerInfo);
    }

    @Deprecated
    public Future<Frame> sendBinary(byte[] bytes, int off, int len, boolean last) {
        this.checkConnectedState();
        return this.protocolHandler.stream(last, bytes, off, len);
    }

    public Future<Frame> sendBinary(byte[] bytes, int off, int len, boolean last, WriterInfo writerInfo) {
        this.checkConnectedState();
        return this.protocolHandler.stream(last, bytes, off, len, writerInfo);
    }

    ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    void setMessageEventListener(MessageEventListener messageEventListener) {
        this.messageEventListener = messageEventListener;
        this.protocolHandler.setMessageEventListener(messageEventListener);
    }

    MessageEventListener getMessageEventListener() {
        return this.messageEventListener;
    }

    private void checkConnectedState() {
        if (!this.isConnected()) {
            throw new RuntimeException(LocalizationMessages.SOCKET_NOT_CONNECTED());
        }
    }

    private static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

