/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.CompoundStatement;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FinallyStatement;
import org.glassfish.rmic.tools.tree.IdentifierExpression;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.Node;
import org.glassfish.rmic.tools.tree.Vset;

public class Statement
extends Node {
    public static final Vset DEAD_END = Vset.DEAD_END;
    Identifier[] labels = null;
    public static final Statement empty = new Statement(105, 0L);
    public static final int MAXINLINECOST = Integer.getInteger("javac.maxinlinecost", 30);

    Statement(int op, long where) {
        super(op, where);
    }

    public static Statement insertStatement(Statement s1, Statement s2) {
        if (s2 == null) {
            s2 = s1;
        } else if (s2 instanceof CompoundStatement) {
            ((CompoundStatement)s2).insertStatement(s1);
        } else {
            Statement[] body = new Statement[]{s1, s2};
            s2 = new CompoundStatement(s1.getWhere(), body);
        }
        return s2;
    }

    public void setLabel(Environment env, Expression e) {
        if (e.op == 60) {
            if (this.labels == null) {
                this.labels = new Identifier[1];
            } else {
                Identifier[] newLabels = new Identifier[this.labels.length + 1];
                System.arraycopy(this.labels, 0, newLabels, 1, this.labels.length);
                this.labels = newLabels;
            }
            this.labels[0] = ((IdentifierExpression)e).id;
        } else {
            env.error(e.where, "invalid.label");
        }
    }

    public Vset checkMethod(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        CheckContext mctx = new CheckContext(ctx, new Statement(47, 0L));
        ctx = mctx;
        vset = this.check(env, ctx, vset, exp);
        if (!ctx.field.getType().getReturnType().isType(11) && !vset.isDeadEnd()) {
            env.error(ctx.field.getWhere(), "return.required.at.end", ctx.field);
        }
        vset = vset.join(mctx.vsBreak);
        return vset;
    }

    Vset checkDeclaration(Environment env, Context ctx, Vset vset, int mod, Type t, Hashtable<Object, Object> exp) {
        throw new CompilerError("checkDeclaration");
    }

    protected void checkLabel(Environment env, Context ctx) {
        if (this.labels != null) {
            block0: for (int i = 0; i < this.labels.length; ++i) {
                for (int j = i + 1; j < this.labels.length; ++j) {
                    if (this.labels[i] != this.labels[j]) continue;
                    env.error(this.where, "nested.duplicate.label", this.labels[i]);
                    continue block0;
                }
                CheckContext destCtx = (CheckContext)ctx.getLabelContext(this.labels[i]);
                if (destCtx == null || destCtx.frameNumber != ctx.frameNumber) continue;
                env.error(this.where, "nested.duplicate.label", this.labels[i]);
            }
        }
    }

    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        throw new CompilerError("check");
    }

    Vset checkBlockStatement(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        return this.check(env, ctx, vset, exp);
    }

    Vset reach(Environment env, Vset vset) {
        if (vset.isDeadEnd()) {
            env.error(this.where, "stat.not.reached");
            vset = vset.clearDeadEnd();
        }
        return vset;
    }

    public Statement inline(Environment env, Context ctx) {
        return this;
    }

    public Statement eliminate(Environment env, Statement s) {
        if (s != null && this.labels != null) {
            Statement[] args = new Statement[]{s};
            s = new CompoundStatement(this.where, args);
            s.labels = this.labels;
        }
        return s;
    }

    public void code(Environment env, Context ctx, Assembler asm) {
        throw new CompilerError("code");
    }

    void codeFinally(Environment env, Context ctx, Assembler asm, Context stopctx, Type save) {
        FinallyStatement st;
        Integer num = null;
        boolean haveCleanup = false;
        boolean haveNonLocalFinally = false;
        Context c = ctx;
        while (c != null && c != stopctx) {
            if (c.node != null) {
                if (c.node.op == 126) {
                    haveCleanup = true;
                } else if (c.node.op == 103 && ((CodeContext)c).contLabel != null) {
                    haveCleanup = true;
                    st = (FinallyStatement)c.node;
                    if (!st.finallyCanFinish) {
                        haveNonLocalFinally = true;
                        break;
                    }
                }
            }
            c = c.prev;
        }
        if (!haveCleanup) {
            return;
        }
        if (save != null) {
            ClassDefinition def = ctx.field.getClassDefinition();
            if (!haveNonLocalFinally) {
                LocalMember lf = ctx.getLocalField(idFinallyReturnValue);
                num = lf.number;
                asm.add(this.where, 54 + save.getTypeCodeOffset(), num);
            } else {
                switch (ctx.field.getType().getReturnType().getTypeCode()) {
                    case 11: {
                        break;
                    }
                    case 5: 
                    case 7: {
                        asm.add(this.where, 88);
                        break;
                    }
                    default: {
                        asm.add(this.where, 87);
                    }
                }
            }
        }
        c = ctx;
        while (c != null && c != stopctx) {
            if (c.node != null) {
                if (c.node.op == 126) {
                    asm.add(this.where, 168, ((CodeContext)c).contLabel);
                } else if (c.node.op == 103 && ((CodeContext)c).contLabel != null) {
                    st = (FinallyStatement)c.node;
                    Label label = ((CodeContext)c).contLabel;
                    if (st.finallyCanFinish) {
                        asm.add(this.where, 168, label);
                    } else {
                        asm.add(this.where, 167, label);
                        break;
                    }
                }
            }
            c = c.prev;
        }
        if (num != null) {
            asm.add(this.where, 21 + save.getTypeCodeOffset(), num);
        }
    }

    public boolean hasLabel(Identifier lbl) {
        Identifier[] labels = this.labels;
        if (labels != null) {
            int i = labels.length;
            while (--i >= 0) {
                if (!labels[i].equals(lbl)) continue;
                return true;
            }
        }
        return false;
    }

    public Expression firstConstructor() {
        return null;
    }

    public Statement copyInline(Context ctx, boolean valNeeded) {
        return (Statement)this.clone();
    }

    public int costInline(int thresh, Environment env, Context ctx) {
        return thresh;
    }

    void printIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("    ");
        }
    }

    public void print(PrintStream out, int indent) {
        if (this.labels != null) {
            int i = this.labels.length;
            while (--i >= 0) {
                out.print(this.labels[i] + ": ");
            }
        }
    }

    @Override
    public void print(PrintStream out) {
        this.print(out, 0);
    }
}

