/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.validation;

import com.sun.xml.ws.api.tx.at.Transactional;
import jakarta.xml.ws.WebServiceException;
import java.util.HashSet;
import java.util.Set;

public class TXAttributesValidator {
    public static final short TX_NOT_SET = -1;
    public static final short TX_NOT_SUPPORTED = 0;
    public static final short TX_REQUIRED = 1;
    public static final short TX_SUPPORTS = 2;
    public static final short TX_REQUIRES_NEW = 3;
    public static final short TX_MANDATORY = 4;
    public static final short TX_NEVER = 5;
    Set<InvalidCombination> inValidateCombinations = new HashSet<InvalidCombination>();
    static Set<Combination> validateCombinations = new HashSet<Combination>();

    public void visitOperation(String operationName, short attribute, Transactional.TransactionFlowType wsatType) {
        TransactionAttributeType ejbTx = TXAttributesValidator.fromIndex(attribute);
        this.visitOperation(operationName, ejbTx, wsatType);
    }

    public void validate() throws WebServiceException {
        StringBuilder sb = new StringBuilder();
        for (InvalidCombination combination : this.inValidateCombinations) {
            sb.append("The effective TransactionAttributeType ").append((Object)combination.ejbTx).append(" and WS-AT Transaction flowType ").append((Object)combination.wsat).append(" on WebService operation ").append(combination.operationName).append(" is not a valid combination! ");
        }
        if (sb.length() > 0) {
            throw new WebServiceException(sb.toString());
        }
    }

    public void visitOperation(String operationName, TransactionAttributeType ejbTx, Transactional.TransactionFlowType wsatType) {
        Combination combination;
        if (wsatType == null) {
            wsatType = Transactional.TransactionFlowType.NEVER;
        }
        if (!validateCombinations.contains(combination = new Combination(ejbTx, wsatType))) {
            this.inValidateCombinations.add(new InvalidCombination(ejbTx, wsatType, operationName));
        }
    }

    public static boolean isValid(TransactionAttributeType ejbTx, Transactional.TransactionFlowType wsatType) {
        return validateCombinations.contains(new Combination(ejbTx, wsatType));
    }

    private static TransactionAttributeType fromIndex(Short index) {
        switch (index) {
            case 0: {
                return TransactionAttributeType.NOT_SUPPORTED;
            }
            case 1: {
                return TransactionAttributeType.REQUIRED;
            }
            case 2: {
                return TransactionAttributeType.SUPPORTS;
            }
            case 3: {
                return TransactionAttributeType.REQUIRES_NEW;
            }
            case 4: {
                return TransactionAttributeType.MANDATORY;
            }
            case 5: {
                return TransactionAttributeType.NEVER;
            }
        }
        return TransactionAttributeType.SUPPORTS;
    }

    static {
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.MANDATORY));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.MANDATORY, Transactional.TransactionFlowType.MANDATORY));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.SUPPORTS));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.SUPPORTS));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRES_NEW, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.NEVER, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.NOT_SUPPORTED, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.MANDATORY));
    }

    public static enum TransactionAttributeType {
        MANDATORY,
        REQUIRED,
        REQUIRES_NEW,
        SUPPORTS,
        NOT_SUPPORTED,
        NEVER;

    }

    static class InvalidCombination {
        TransactionAttributeType ejbTx;
        Transactional.TransactionFlowType wsat;
        String operationName;

        InvalidCombination(TransactionAttributeType ejbTx, Transactional.TransactionFlowType wsat, String operationName) {
            this.ejbTx = ejbTx;
            this.wsat = wsat;
            this.operationName = operationName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidCombination that = (InvalidCombination)o;
            if (this.ejbTx != that.ejbTx) {
                return false;
            }
            if (!this.operationName.equals(that.operationName)) {
                return false;
            }
            return this.wsat == that.wsat;
        }

        public int hashCode() {
            int result = this.ejbTx.hashCode();
            result = 31 * result + this.wsat.hashCode();
            result = 31 * result + this.operationName.hashCode();
            return result;
        }
    }

    static class Combination {
        TransactionAttributeType ejbTx;
        Transactional.TransactionFlowType wsat;

        Combination(TransactionAttributeType ejbTx, Transactional.TransactionFlowType wsat) {
            this.ejbTx = ejbTx;
            this.wsat = wsat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Combination that = (Combination)o;
            if (this.ejbTx != that.ejbTx) {
                return false;
            }
            return this.wsat == that.wsat;
        }

        public int hashCode() {
            int result = this.ejbTx.hashCode();
            result = 31 * result + this.wsat.hashCode();
            return result;
        }
    }
}

