/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyProtocolImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Map;

public class GrizzlyIPServiceFactory
extends IMQIPServiceFactory {
    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        String myname = "shared";
        if (!myname.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myname);
        }
    }

    @Override
    public void updateService(Service s) throws BrokerException {
        if (!(s instanceof GrizzlyIPService)) {
            throw new BrokerException(this.br.getKString("B3100", "Unexpected service class: " + String.valueOf(s)));
        }
        GrizzlyIPService ss = (GrizzlyIPService)s;
        try {
            ss.updateService(((GrizzlyProtocolImpl)ss.getProtocol()).getPort(), this.getThreadMin(s.getName()), this.getThreadMax(s.getName()), false);
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public Service createService(String name, int type) throws BrokerException {
        GrizzlyIPService s = new GrizzlyIPService(name, type, Globals.getPacketRouter(type), this.getThreadMin(name), this.getThreadMax(name), this);
        long timeout = this.getPoolTimeout(name);
        if (timeout > 0L) {
            s.setDestroyWaitTime(timeout);
        }
        return s;
    }

    @Override
    protected IMQService createService(String instancename, Protocol proto, PacketRouter router, int type, int min, int max) throws IOException {
        throw new UnsupportedOperationException("Unexpected call");
    }

    @Override
    protected Map getProtocolParams(String protoname, String prefix) {
        return super.getProtocolParams(protoname, prefix);
    }
}

