/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import jakarta.xml.ws.WebServiceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceContractImpl;

public class ResourceInjectorImpl
extends ResourceInjector {
    private final WebServiceEndpoint endpoint;
    private final ComponentInvocation inv;
    private final InvocationManager invMgr;
    private static final Logger logger = LogUtils.getLogger();

    public ResourceInjectorImpl(WebServiceEndpoint ep) {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        this.invMgr = wscImpl.getInvocationManager();
        this.inv = this.invMgr.getCurrentInvocation();
        this.endpoint = ep;
    }

    public void inject(WSWebServiceContext context, Object instance) throws WebServiceException {
        try {
            this.invMgr.preInvoke(this.inv);
            InjectionManager injManager = WebServiceContractImpl.getInstance().getInjectionManager();
            injManager.injectInstance(instance);
            WebServiceContextImpl wsc = null;
            WebBundleDescriptor bundle = (WebBundleDescriptor)this.endpoint.getBundleDescriptor();
            for (ResourceReferenceDescriptor r : bundle.getResourceReferenceDescriptors()) {
                block9: {
                    if (!r.isWebServiceContext()) continue;
                    boolean matchingClassFound = false;
                    for (InjectionTarget target : r.getInjectionTargets()) {
                        if (!this.endpoint.getServletImplClass().equals(target.getClassName())) continue;
                        matchingClassFound = true;
                        break;
                    }
                    if (!matchingClassFound) continue;
                    try {
                        InitialContext ic = new InitialContext();
                        wsc = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.FINE)) break block9;
                        logger.log(Level.FINE, "AS-WSJSR109IMPL-00050", t);
                    }
                }
                if (wsc == null) continue;
                wsc.setContextDelegate(context);
                wsc.setServletName(bundle.getWebComponentDescriptors());
            }
        }
        catch (InjectionException ie) {
            throw new WebServiceException((Throwable)ie);
        }
        finally {
            this.invMgr.postInvoke(this.inv);
        }
    }
}

