/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class LabelRenderer
extends Renderer {
    private static final String[] EVENT_NAMES = new String[]{"onClick", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut"};

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String value;
        if (!(component instanceof Label)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Label.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Label.renderer", params);
            throw new FacesException(message);
        }
        Label label = (Label)component;
        if (LogUtil.fineEnabled(LabelRenderer.class)) {
            LogUtil.fine(LabelRenderer.class, "Label.renderAttributes", new Object[]{label.getId(), label.getFor()});
        }
        EditableValueHolder comp = label.getLabeledComponent();
        boolean requiredFlag = label.isRequiredIndicator();
        boolean errorFlag = false;
        if (!label.isHideIndicators() && comp != null) {
            Object o = ((UIComponent)comp).getAttributes().get("readOnly");
            if (o != null && o instanceof Boolean && o.equals(Boolean.TRUE)) {
                requiredFlag = false;
                errorFlag = false;
            } else {
                requiredFlag = comp.isRequired();
                errorFlag = !comp.isValid();
            }
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String styleClass = this.getThemeStyleClass(label, theme, errorFlag);
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getLabeledElementId(context, label);
        this.startElement(context, label, styleClass, id, writer);
        if (errorFlag) {
            writer.write("\n");
            RenderingUtilities.renderComponent(label.getErrorIcon(theme, context, false), context);
        }
        if ((value = this.formatLabelText(context, label)) != null) {
            writer.write("\n");
            writer.writeText((Object)value, "text");
            writer.writeText((Object)"\n", null);
        }
        if (requiredFlag) {
            writer.write("\n");
            RenderingUtilities.renderComponent(label.getRequiredIcon(theme, context), context);
        }
        writer.endElement("label");
        Iterator children = label.getChildren().iterator();
        while (children.hasNext()) {
            RenderingUtilities.renderComponent((UIComponent)children.next(), context);
            writer.writeText((Object)"\n", null);
        }
        if (LogUtil.finestEnabled(LabelRenderer.class)) {
            LogUtil.finest(LabelRenderer.class, "Label.renderEnd");
        }
    }

    private void startElement(FacesContext context, Label label, String styleClass, String forId, ResponseWriter writer) throws IOException {
        String toolTip;
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)label.getClientId(context), "id");
        if (forId != null && forId.length() != 0) {
            writer.writeAttribute("for", (Object)forId, "for");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)label, styleClass);
        if (label.getStyle() != null) {
            writer.writeAttribute("style", (Object)label.getStyle(), "style");
        }
        if ((toolTip = label.getToolTip()) != null) {
            writer.writeAttribute("title", (Object)toolTip, "toolTip");
        }
        this.writeEvents(label, writer);
    }

    protected String getLabeledElementId(FacesContext context, Label label) throws IOException {
        String id = label.getFor();
        if (id == null) {
            id = this.getLabeledChildId(context, (UIComponent)label);
        } else if (id.indexOf(UINamingContainer.getSeparatorChar((FacesContext)context)) == -1) {
            UIComponent comp = label.getParent();
            if (comp != null && (comp = comp.findComponent(id)) != null) {
                id = comp instanceof ComplexComponent ? ((ComplexComponent)comp).getLabeledElementId(context) : comp.getClientId(context);
            }
        } else {
            id = RenderingUtilities.getLabeledElementId(context, id);
        }
        return id;
    }

    private String formatLabelText(FacesContext context, Label label) {
        String text = ConversionUtilities.convertValueToString((UIComponent)label, label.getValue());
        text = text.concat(" ");
        if (label.getChildCount() == 0) {
            return text;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (UIComponent kid : label.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            list.add(((UIParameter)kid).getValue());
        }
        if (list.isEmpty()) {
            return text;
        }
        return MessageFormat.format(text, list.toArray(new Object[list.size()]));
    }

    private String getThemeStyleClass(Label label, Theme theme, boolean errorFlag) {
        String style = null;
        int level = label.getLabelLevel();
        if (errorFlag) {
            style = theme.getStyleClass("CONTENT_ERROR_LABEL_TEXT");
        } else if (level == 1) {
            style = theme.getStyleClass("LABEL_LEVEL_ONE_TEXT");
        } else if (level == 2) {
            style = theme.getStyleClass("LABEL_LEVEL_TWO_TEXT");
        } else if (level == 3) {
            style = theme.getStyleClass("LABEL_LEVEL_THREE_TEXT");
        }
        return style;
    }

    private void writeEvents(Label label, ResponseWriter writer) throws IOException {
        Map attributes = label.getAttributes();
        int length = EVENT_NAMES.length;
        for (int i = 0; i < length; ++i) {
            Object value = attributes.get(EVENT_NAMES[i]);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)((String)value), EVENT_NAMES[i]);
                continue;
            }
            writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)value.toString(), EVENT_NAMES[i]);
        }
    }

    private String getLabeledChildId(FacesContext context, UIComponent component) {
        if (component.getChildCount() == 0) {
            if (LogUtil.fineEnabled(LabelRenderer.class)) {
                LogUtil.fine(LabelRenderer.class, "No children available");
            }
            return null;
        }
        UIComponent child = (UIComponent)component.getChildren().get(0);
        if (child instanceof ComplexComponent) {
            return ((ComplexComponent)child).getLabeledElementId(context);
        }
        return child.getClientId(context);
    }
}

