/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.spi.logging.InterceptorsSystemException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorList {
    private static final InterceptorsSystemException wrapper = InterceptorsSystemException.self;
    static final int INTERCEPTOR_TYPE_CLIENT = 0;
    static final int INTERCEPTOR_TYPE_SERVER = 1;
    static final int INTERCEPTOR_TYPE_IOR = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{ClientRequestInterceptor.class, ServerRequestInterceptor.class, IORInterceptor.class};
    private boolean locked = false;
    private Interceptor[][] interceptors = new Interceptor[3][];

    InterceptorList() {
        this.initInterceptorArrays();
    }

    void register_interceptor(Interceptor interceptor, int type) throws DuplicateName {
        if (this.locked) {
            throw wrapper.interceptorListLocked();
        }
        String interceptorName = interceptor.name();
        boolean anonymous = interceptorName.equals("");
        boolean foundDuplicate = false;
        Interceptor[] interceptorList = this.interceptors[type];
        if (!anonymous) {
            for (Interceptor in : interceptorList) {
                if (!in.name().equals(interceptorName)) continue;
                foundDuplicate = true;
                break;
            }
        }
        if (foundDuplicate) {
            throw new DuplicateName(interceptorName);
        }
        this.growInterceptorArray(type);
        this.interceptors[type][this.interceptors[type].length - 1] = interceptor;
    }

    void lock() {
        this.locked = true;
    }

    Interceptor[] getInterceptors(int type) {
        return this.interceptors[type];
    }

    boolean hasInterceptorsOfType(int type) {
        return this.interceptors[type].length > 0;
    }

    private void initInterceptorArrays() {
        for (int type = 0; type < 3; ++type) {
            Class classType = classTypes[type];
            this.interceptors[type] = (Interceptor[])Array.newInstance(classType, 0);
        }
    }

    private void growInterceptorArray(int type) {
        Class classType = classTypes[type];
        int currentLength = this.interceptors[type].length;
        Interceptor[] replacementArray = (Interceptor[])Array.newInstance(classType, currentLength + 1);
        System.arraycopy(this.interceptors[type], 0, replacementArray, 0, currentLength);
        this.interceptors[type] = replacementArray;
    }

    void destroyAll() {
        int numTypes = this.interceptors.length;
        for (int i = 0; i < numTypes; ++i) {
            int numInterceptors = this.interceptors[i].length;
            for (int j = 0; j < numInterceptors; ++j) {
                this.interceptors[i][j].destroy();
            }
        }
    }

    void sortInterceptors() {
        ArrayList<Interceptor> sorted = null;
        ArrayList<Interceptor> unsorted = null;
        int numTypes = this.interceptors.length;
        for (int i = 0; i < numTypes; ++i) {
            int numInterceptors = this.interceptors[i].length;
            if (numInterceptors > 0) {
                sorted = new ArrayList<Interceptor>();
                unsorted = new ArrayList<Interceptor>();
            }
            for (int j = 0; j < numInterceptors; ++j) {
                Interceptor interceptor = this.interceptors[i][j];
                if (interceptor instanceof Comparable) {
                    sorted.add(interceptor);
                    continue;
                }
                unsorted.add(interceptor);
            }
            if (numInterceptors <= 0 || sorted.size() <= 0) continue;
            Collections.sort((List)List.class.cast(sorted));
            Iterator sortedIterator = sorted.iterator();
            Iterator unsortedIterator = unsorted.iterator();
            for (int j = 0; j < numInterceptors; ++j) {
                if (sortedIterator.hasNext()) {
                    this.interceptors[i][j] = (Interceptor)sortedIterator.next();
                    continue;
                }
                if (unsortedIterator.hasNext()) {
                    this.interceptors[i][j] = (Interceptor)unsortedIterator.next();
                    continue;
                }
                throw wrapper.sortSizeMismatch();
            }
        }
    }
}

