/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.UpdateThread;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;

public class CoordinatorUtil {
    public static boolean addToCoordination(Object srv, UpdateThread thread, Runnable task) {
        Coordinator coordinator = (Coordinator)srv;
        Coordination c = coordinator.peek();
        if (c != null && !c.isTerminated()) {
            Notifier n = null;
            for (Participant p : c.getParticipants()) {
                if (!(p instanceof Notifier)) continue;
                n = (Notifier)p;
                break;
            }
            if (n == null) {
                n = new Notifier(thread);
                c.addParticipant((Participant)n);
            }
            n.add(task);
            return true;
        }
        return false;
    }

    public static final class Notifier
    implements Participant {
        private final List<Runnable> runnables = new ArrayList<Runnable>();
        private final UpdateThread thread;

        public Notifier(UpdateThread t) {
            this.thread = t;
        }

        private List<Runnable> compact() {
            Runnable up;
            Runnable current;
            ArrayList<Runnable> result = new ArrayList<Runnable>(this.runnables);
            this.runnables.clear();
            HashMap<String, ConfigurationManager.UpdateConfiguration> lastOperations = new HashMap<String, ConfigurationManager.UpdateConfiguration>();
            HashMap<String, Boolean> firstOperationIsCreate = new HashMap<String, Boolean>();
            for (int i = 0; i < result.size(); ++i) {
                ConfigurationManager.ConfigurationProvider last;
                String pid;
                current = (Runnable)result.get(i);
                if (current instanceof ConfigurationManager.UpdateConfiguration) {
                    up = (ConfigurationManager.UpdateConfiguration)current;
                    pid = up.getTargetedServicePid().getServicePid();
                    if (firstOperationIsCreate.get(pid) == null) {
                        firstOperationIsCreate.put(pid, up.revision == 1L);
                    }
                    last = (ConfigurationManager.ConfigurationProvider)lastOperations.get(pid);
                    lastOperations.put(pid, (ConfigurationManager.UpdateConfiguration)up);
                    if (last == null) continue;
                    result.remove(last);
                    --i;
                    continue;
                }
                if (!(current instanceof ConfigurationManager.DeleteConfiguration)) continue;
                up = (ConfigurationManager.DeleteConfiguration)current;
                pid = up.getTargetedServicePid().getServicePid();
                if (firstOperationIsCreate.get(pid) == null) {
                    firstOperationIsCreate.put(pid, false);
                }
                last = (ConfigurationManager.ConfigurationProvider)lastOperations.get(pid);
                lastOperations.put(pid, (ConfigurationManager.UpdateConfiguration)up);
                if (last == null) continue;
                if (!((Boolean)firstOperationIsCreate.get(pid)).booleanValue()) {
                    firstOperationIsCreate.remove(pid);
                    result.remove(i);
                    --i;
                    lastOperations.remove(pid);
                }
                result.remove(last);
                --i;
            }
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                current = (Runnable)iter.next();
                if (!(current instanceof ConfigurationManager.ManagedServiceUpdate)) continue;
                up = (ConfigurationManager.ManagedServiceUpdate)current;
                Iterator<String> pidIter = ((ConfigurationManager.ManagedServiceUpdate)up).pids.iterator();
                while (pidIter.hasNext()) {
                    String pid = pidIter.next();
                    ConfigurationManager.ConfigurationProvider last = (ConfigurationManager.ConfigurationProvider)lastOperations.get(pid);
                    if (last == null) continue;
                    pidIter.remove();
                }
                if (!((ConfigurationManager.ManagedServiceUpdate)up).pids.isEmpty()) continue;
                iter.remove();
            }
            return result;
        }

        private void execute() {
            for (Runnable r : this.compact()) {
                this.thread.schedule(r);
            }
        }

        public void ended(Coordination coordination) throws Exception {
            this.execute();
        }

        public void failed(Coordination coordination) throws Exception {
            this.execute();
        }

        public void add(Runnable t) {
            this.runnables.add(t);
        }
    }
}

