/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;

public class ServiceRefPortInfo
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private String serviceEndpointInterface;
    private boolean containerManaged;
    private String portComponentLinkName;
    private WebServiceEndpoint portComponentLink;
    private ServiceReferenceDescriptor serviceRef;
    private QName wsdlPort;
    private final Set<NameValuePairDescriptor> stubProperties;
    private final Set<NameValuePairDescriptor> callProperties;
    private String targetEndpointAddress;
    private MessageSecurityBindingDescriptor messageSecBindingDesc;
    private String mtomEnabled;

    public ServiceRefPortInfo(ServiceRefPortInfo other) {
        super((Descriptor)other);
        this.serviceEndpointInterface = other.serviceEndpointInterface;
        this.containerManaged = other.containerManaged;
        this.portComponentLinkName = other.portComponentLinkName;
        this.portComponentLink = other.portComponentLink;
        this.serviceRef = other.serviceRef;
        this.wsdlPort = other.wsdlPort;
        this.mtomEnabled = other.mtomEnabled;
        this.stubProperties = new HashSet<NameValuePairDescriptor>();
        for (NameValuePairDescriptor element : other.stubProperties) {
            this.stubProperties.add(new NameValuePairDescriptor(element));
        }
        this.callProperties = new HashSet<NameValuePairDescriptor>();
        for (NameValuePairDescriptor element : other.callProperties) {
            this.callProperties.add(new NameValuePairDescriptor(element));
        }
        this.targetEndpointAddress = other.targetEndpointAddress;
    }

    public ServiceRefPortInfo() {
        this.stubProperties = new HashSet<NameValuePairDescriptor>();
        this.callProperties = new HashSet<NameValuePairDescriptor>();
        this.containerManaged = false;
    }

    public void setServiceReference(ServiceReferenceDescriptor desc) {
        this.serviceRef = desc;
    }

    public ServiceReferenceDescriptor getServiceReference() {
        return this.serviceRef;
    }

    public boolean hasServiceEndpointInterface() {
        return this.serviceEndpointInterface != null;
    }

    public void setServiceEndpointInterface(String sei) {
        this.serviceEndpointInterface = sei;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setIsContainerManaged(boolean flag) {
        this.containerManaged = flag;
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public boolean isClientManaged() {
        return !this.containerManaged;
    }

    public void setPortComponentLinkName(String linkName) {
        this.setPortComponentLinkName(linkName, false);
    }

    public WebServiceEndpoint setPortComponentLinkName(String linkName, boolean resolve) {
        this.portComponentLinkName = linkName;
        return resolve ? this.resolveLinkName() : null;
    }

    public boolean hasPortComponentLinkName() {
        return this.portComponentLinkName != null;
    }

    public String getPortComponentLinkName() {
        return this.portComponentLinkName;
    }

    public void setMessageSecurityBinding(MessageSecurityBindingDescriptor messageSecBindingDesc) {
        this.messageSecBindingDesc = messageSecBindingDesc;
    }

    public MessageSecurityBindingDescriptor getMessageSecurityBinding() {
        return this.messageSecBindingDesc;
    }

    public boolean isLinkedToPortComponent() {
        return this.portComponentLinkName != null && this.portComponentLink != null;
    }

    public WebServiceEndpoint resolveLinkName() {
        String portName;
        BundleDescriptor targetBundle;
        String linkName = this.portComponentLinkName;
        if (linkName == null || linkName.isEmpty()) {
            return null;
        }
        int hashIndex = linkName.indexOf(35);
        boolean relativeLink = hashIndex == -1;
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
        Application app = bundleDescriptor.getApplication();
        if (app == null || relativeLink) {
            targetBundle = bundleDescriptor;
            portName = linkName;
        } else {
            String relativeModuleUri = linkName.substring(0, hashIndex);
            portName = linkName.substring(hashIndex + 1);
            targetBundle = app.getRelativeBundle(bundleDescriptor, relativeModuleUri);
        }
        if (targetBundle == null) {
            return null;
        }
        LinkedList<BundleDescriptor> bundles = new LinkedList<BundleDescriptor>();
        bundles.addFirst(targetBundle);
        if (app != null && relativeLink) {
            bundles.addAll(app.getBundleDescriptors());
        }
        for (BundleDescriptor bundle : bundles) {
            WebServiceEndpoint port = bundle.getWebServiceEndpointByName(portName);
            if (port == null) continue;
            this.setPortComponentLink(port);
            return port;
        }
        return null;
    }

    public WebServiceEndpoint getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(WebServiceEndpoint newPort) {
        if (newPort != null) {
            BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
            BundleDescriptor targetBundleDescriptor = newPort.getBundleDescriptor();
            Object linkName = newPort.getEndpointName();
            if (bundleDescriptor != targetBundleDescriptor) {
                Application app = bundleDescriptor.getApplication();
                String relativeUri = app.getRelativeUri(bundleDescriptor, targetBundleDescriptor);
                linkName = relativeUri + "#" + (String)linkName;
            }
            this.portComponentLinkName = linkName;
        }
        this.portComponentLink = newPort;
    }

    private BundleDescriptor getBundleDescriptor() {
        return this.serviceRef.getBundleDescriptor();
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public Set<NameValuePairDescriptor> getStubProperties() {
        return this.stubProperties;
    }

    public boolean hasStubProperty(String name) {
        return this.getStubPropertyValue(name) != null;
    }

    public String getStubPropertyValue(String name) {
        for (NameValuePairDescriptor element : this.stubProperties) {
            if (!element.getName().equals(name)) continue;
            return element.getValue();
        }
        return null;
    }

    public NameValuePairDescriptor getStubPropertyByName(String name) {
        for (NameValuePairDescriptor element : this.stubProperties) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public void addStubProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getStubPropertyByName(property.getName());
        if (prop == null) {
            this.stubProperties.add(property);
        } else {
            prop.setValue(property.getValue());
        }
    }

    public void removeStubProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getStubPropertyByName(property.getName());
        if (prop != null) {
            this.stubProperties.remove((Object)property);
        }
    }

    public void addStubProperty(String name, String value) {
        NameValuePairDescriptor nvPair = new NameValuePairDescriptor();
        nvPair.setName(name);
        nvPair.setValue(value);
        this.addStubProperty(nvPair);
    }

    public Set<NameValuePairDescriptor> getCallProperties() {
        return this.callProperties;
    }

    public boolean hasCallProperty(String name) {
        return this.getCallPropertyByName(name) != null;
    }

    public NameValuePairDescriptor getCallPropertyByName(String name) {
        for (NameValuePairDescriptor next : this.callProperties) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public void addCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop == null) {
            this.callProperties.add(property);
        } else {
            prop.setValue(property.getValue());
        }
    }

    public void removeCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop != null) {
            this.callProperties.remove((Object)property);
        }
    }

    public boolean hasTargetEndpointAddress() {
        return this.targetEndpointAddress != null;
    }

    public void setTargetEndpointAddress(String address) {
        this.targetEndpointAddress = address;
    }

    public String getTargetEndpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setMtomEnabled(String value) {
        this.mtomEnabled = value;
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }
}

