/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public final class Classpath {
    private static final String[] PREFIXES_TO_EXCLUDE = new String[]{"rar:", "sar:"};
    private static final String[] EXTENSIONS_TO_EXCLUDE = new String[]{".rar", ".sar"};

    public static URL[] search(String prefix, String suffix) throws IOException {
        return Classpath.search(Thread.currentThread().getContextClassLoader(), prefix, suffix, SearchAdvice.AllMatches);
    }

    public static URL[] search(ClassLoader cl, String prefix, String suffix) throws IOException {
        return Classpath.search(cl, prefix, suffix, SearchAdvice.AllMatches);
    }

    public static URL[] search(ClassLoader classLoader, String prefix, String suffix, SearchAdvice advice) throws IOException {
        List<Enumeration> urlResources = Arrays.asList(classLoader.getResources(prefix), classLoader.getResources(prefix + "MANIFEST.MF"));
        LinkedHashSet<URL> allUrls = new LinkedHashSet<URL>();
        for (Enumeration urlResource : urlResources) {
            while (urlResource.hasMoreElements()) {
                JarFile jarFile;
                URL url = (URL)urlResource.nextElement();
                String str = url.getPath();
                if (-1 != str.indexOf("%2520")) {
                    str = url.toExternalForm();
                    str = str.replace("%2520", "%20");
                    url = new URL(str);
                }
                if ((jarFile = Classpath.getJarFile(url)) != null) {
                    Classpath.searchJar(classLoader, allUrls, jarFile, prefix, suffix, advice);
                    continue;
                }
                boolean searchDone = Classpath.searchDir(allUrls, new File(URLDecoder.decode(url.getFile(), "UTF-8")), suffix);
                if (searchDone) continue;
                Classpath.searchFromURL(allUrls, prefix, suffix, url);
            }
        }
        return allUrls.toArray(new URL[allUrls.size()]);
    }

    private static JarFile getJarFile(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        if (urlConnection instanceof JarURLConnection) {
            return ((JarURLConnection)urlConnection).getJarFile();
        }
        return Classpath.getAlternativeJarFile(url);
    }

    private static JarFile getAlternativeJarFile(URL url) throws IOException {
        return Classpath.getAlternativeJarFile(url.getFile());
    }

    static JarFile getAlternativeJarFile(String urlFile) throws IOException {
        JarFile alternativeJarFile = null;
        int bangSlash = urlFile.indexOf("!/");
        int bang = urlFile.indexOf(33);
        int separatorIndex = -1;
        if (-1 != bangSlash || -1 != bang) {
            separatorIndex = bangSlash < bang ? bangSlash : bang;
        }
        if (separatorIndex == -1) {
            return null;
        }
        String jarFileUrl = urlFile.substring(0, separatorIndex);
        if (jarFileUrl.startsWith("file:")) {
            jarFileUrl = jarFileUrl.substring("file:".length());
            jarFileUrl = URLDecoder.decode(jarFileUrl, "UTF-8");
        }
        boolean foundExclusion = false;
        for (int i = 0; i < PREFIXES_TO_EXCLUDE.length; ++i) {
            if (!jarFileUrl.startsWith(PREFIXES_TO_EXCLUDE[i]) && !jarFileUrl.endsWith(EXTENSIONS_TO_EXCLUDE[i])) continue;
            foundExclusion = true;
            break;
        }
        if (!foundExclusion) {
            try {
                alternativeJarFile = new JarFile(jarFileUrl);
            }
            catch (ZipException ze) {
                alternativeJarFile = null;
            }
        }
        return alternativeJarFile;
    }

    private static void searchJar(ClassLoader classLoader, Set<URL> urls, JarFile file, String prefix, String suffix, SearchAdvice advice) throws IOException {
        Enumeration<JarEntry> jarEntries = file.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry;
            try {
                entry = jarEntries.nextElement();
            }
            catch (Throwable t) {
                continue;
            }
            String name = entry.getName();
            if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
            Enumeration<URL> resourcesFromClassLoader = classLoader.getResources(name);
            while (resourcesFromClassLoader.hasMoreElements()) {
                urls.add(resourcesFromClassLoader.nextElement());
                if (advice != SearchAdvice.FirstMatchOnly) continue;
                return;
            }
        }
    }

    private static boolean searchDir(Set<URL> result, File directory, String suffix) throws IOException {
        if (directory.exists() && directory.isDirectory()) {
            File[] filesInDir = directory.listFiles();
            if (filesInDir == null) {
                return false;
            }
            for (File fileInDir : filesInDir) {
                if (fileInDir.isDirectory()) {
                    Classpath.searchDir(result, fileInDir, suffix);
                    continue;
                }
                if (!fileInDir.getAbsolutePath().endsWith(suffix)) continue;
                result.add(fileInDir.toURL());
            }
            return true;
        }
        return false;
    }

    private static void searchFromURL(Set<URL> result, String prefix, String suffix, URL url) throws IOException {
        boolean done = false;
        InputStream urlInputStream = Classpath.getInputStream(url);
        if (urlInputStream != null) {
            try (ZipInputStream zipInputStream = urlInputStream instanceof ZipInputStream ? (ZipInputStream)urlInputStream : new ZipInputStream(urlInputStream);){
                ZipEntry entry = zipInputStream.getNextEntry();
                boolean bl = done = entry != null;
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.endsWith(suffix)) {
                        String urlString = url.toExternalForm();
                        result.add(new URL(urlString + entryName));
                    }
                    entry = zipInputStream.getNextEntry();
                }
            }
        }
        if (!done && prefix.length() > 0) {
            Object urlString = url.toExternalForm() + "/";
            String[] split = prefix.split("/");
            prefix = Classpath.join(split, true);
            String end = Classpath.join(split, false);
            int p = ((String)urlString).lastIndexOf(end);
            if (p < 0) {
                return;
            }
            urlString = ((String)urlString).substring(0, p);
            for (String prefixToExclude : PREFIXES_TO_EXCLUDE) {
                if (!((String)urlString).startsWith(prefixToExclude)) continue;
                return;
            }
            Classpath.searchFromURL(result, prefix, suffix, new URL((String)urlString));
        }
    }

    private static String join(String[] tokens, boolean excludeLast) {
        StringBuffer join = new StringBuffer();
        for (int i = 0; i < tokens.length - (excludeLast ? 1 : 0); ++i) {
            join.append(tokens[i]).append("/");
        }
        return join.toString();
    }

    private static InputStream getInputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static enum SearchAdvice {
        FirstMatchOnly,
        AllMatches;

    }
}

