/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.integration;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class PermsHolder {
    private ConcurrentHashMap<String, PermissionCollection> loaderPC = new ConcurrentHashMap();
    private PermissionCollection eePermissionCollection;
    private PermissionCollection declaredPermissionCollection;

    public PermsHolder() {
    }

    public PermsHolder(PermissionCollection eePC, PermissionCollection declPC, PermissionCollection restrictPC) {
        this.setEEPermissions(eePC);
        this.setDeclaredPermissions(declPC);
        this.setRestrictPermissions(restrictPC);
    }

    public void setEEPermissions(PermissionCollection eePc) {
        this.eePermissionCollection = eePc;
    }

    public void setDeclaredPermissions(PermissionCollection declaredPc) {
        this.declaredPermissionCollection = declaredPc;
    }

    public void setRestrictPermissions(PermissionCollection restrictPC) {
    }

    public PermissionCollection getCachedPerms(CodeSource codesource) {
        if (codesource == null) {
            return null;
        }
        return this.loaderPC.get(codesource.getLocation().toString());
    }

    public PermissionCollection getPermissions(CodeSource codesource, PermissionCollection parentPC) {
        PermissionCollection tmpPermissionCollection;
        String codeUrl = codesource.getLocation().toString();
        PermissionCollection cachedPermissons = this.loaderPC.get(codeUrl);
        if (cachedPermissons != null) {
            return cachedPermissons;
        }
        cachedPermissons = new Permissions();
        PermissionCollection permissionCollection = parentPC;
        if (permissionCollection != null) {
            Enumeration<Permission> permissions = permissionCollection.elements();
            while (permissions.hasMoreElements()) {
                cachedPermissons.add(permissions.nextElement());
            }
        }
        if (this.declaredPermissionCollection != null) {
            Enumeration<Permission> declaredPermissions = this.declaredPermissionCollection.elements();
            while (declaredPermissions.hasMoreElements()) {
                cachedPermissons.add(declaredPermissions.nextElement());
            }
        }
        if (this.eePermissionCollection != null) {
            Enumeration<Permission> eePermissions = this.eePermissionCollection.elements();
            while (eePermissions.hasMoreElements()) {
                cachedPermissons.add(eePermissions.nextElement());
            }
        }
        if ((tmpPermissionCollection = this.loaderPC.putIfAbsent(codeUrl, cachedPermissons)) != null) {
            cachedPermissons = tmpPermissionCollection;
        }
        return cachedPermissons;
    }
}

