/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.common;

import java.util.Arrays;
import java.util.Objects;
import org.glassfish.security.common.UserPrincipal;

public class UserNameAndPassword
implements UserPrincipal {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final char[] password;
    private final int hashCode;

    public UserNameAndPassword(String name) {
        this(name, (char[])null);
    }

    public UserNameAndPassword(String name, String password) {
        this(name, password == null ? null : password.toCharArray());
    }

    public UserNameAndPassword(String name, char[] password) {
        this.name = Objects.requireNonNull(name);
        this.password = password == null ? null : Arrays.copyOf(password, password.length);
        this.hashCode = 31 * name.hashCode() + Arrays.hashCode(this.password);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getStringPassword() {
        return this.password == null ? null : new String(this.password);
    }

    public final char[] getPassword() {
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UserNameAndPassword) {
            UserNameAndPassword another = (UserNameAndPassword)o;
            return Objects.equals(this.getName(), another.getName()) && Objects.equals(this.getPassword(), another.getPassword());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "UserNameAndPassword[" + this.name + "]";
    }
}

