/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.enterprise.transaction.spi.RecoveryResourceListener;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourceRecoveryManagerImpl
implements PostConstruct,
ResourceRecoveryManager {
    private static Logger _logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, (String)"jakarta.enterprise.resource.jta");
    private static StringManager localStrings = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private static List<RecoveryResourceHandler> externallyRegisteredRecoveryResourceHandlers = new ArrayList<RecoveryResourceHandler>();
    @Inject
    private ServiceLocator serviceLocator;
    private TransactionService transactionService;
    private JavaEETransactionManager eeTransactionManager;
    private Collection<RecoveryResourceHandler> recoveryResourceHandlers;
    private RecoveryResourceRegistry recoveryListenersRegistry;
    private volatile boolean lazyRecovery;
    private volatile boolean configured;

    public void postConstruct() {
        if (this.configured) {
            _logger.log(Level.WARNING, "", new IllegalStateException());
            return;
        }
        this.recoverXAResources();
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath) throws Exception {
        return this.recoverIncompleteTx(delegated, logPath, delegated ? null : Configuration.getPropertyValue("com.sun.jts.instancename"), false);
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, String instance, boolean notifyRecoveryListeners) throws Exception {
        boolean result = false;
        Map<RecoveryResourceHandler, Vector> handlerToXAResourcesMap = null;
        try {
            _logger.log(Level.FINE, "Performing recovery of incomplete Tx...");
            this.configure();
            if (notifyRecoveryListeners) {
                this.beforeRecovery(delegated, instance);
            }
            Vector xaresList = new Vector();
            handlerToXAResourcesMap = this.getAllRecoverableResources(xaresList);
            int size = xaresList.size();
            XAResource[] xaresArray = new XAResource[size];
            for (int i = 0; i < size; ++i) {
                xaresArray[i] = (XAResource)xaresList.elementAt(i);
            }
            if (_logger.isLoggable(Level.FINE)) {
                String msg = localStrings.getStringWithDefault("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
                _logger.log(Level.FINE, msg);
            }
            if (!delegated) {
                RecoveryManager.recoverIncompleteTx(xaresArray);
                result = true;
            } else {
                result = DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception ex1) {
            _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
            throw ex1;
        }
        finally {
            try {
                this.closeAllResources(handlerToXAResourcesMap);
            }
            catch (Exception ex1) {
                _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
            }
            if (notifyRecoveryListeners) {
                this.afterRecovery(result, delegated, instance);
            }
        }
    }

    private void closeAllResources(Map<RecoveryResourceHandler, Vector> resourcesToHandlers) {
        if (resourcesToHandlers != null) {
            Set<Map.Entry<RecoveryResourceHandler, Vector>> entries = resourcesToHandlers.entrySet();
            for (Map.Entry<RecoveryResourceHandler, Vector> entry : entries) {
                RecoveryResourceHandler handler = entry.getKey();
                Vector resources = entry.getValue();
                handler.closeConnections((List)resources);
            }
        }
    }

    private Map<RecoveryResourceHandler, Vector> getAllRecoverableResources(Vector xaresList) {
        HashMap<RecoveryResourceHandler, Vector> resourcesToHandlers = new HashMap<RecoveryResourceHandler, Vector>();
        for (RecoveryResourceHandler handler : this.recoveryResourceHandlers) {
            Vector resources = new Vector();
            handler.loadXAResourcesAndItsConnections((List)xaresList, resources);
            resourcesToHandlers.put(handler, resources);
        }
        return resourcesToHandlers;
    }

    public void recoverXAResources(boolean force) {
        if (force) {
            try {
                if (this.transactionService == null) {
                    this.transactionService = (TransactionService)((Config)this.serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])).getExtensionByType(TransactionService.class);
                }
                if (!Boolean.valueOf(this.transactionService.getAutomaticRecovery()).booleanValue()) {
                    return;
                }
                _logger.log(Level.FINE, "ejbserver.recovery", "Perform recovery of XAResources...");
                this.configure();
                Vector xaresList = new Vector();
                Map<RecoveryResourceHandler, Vector> resourcesToHandler = this.getAllRecoverableResources(xaresList);
                int size = xaresList.size();
                XAResource[] xaresArray = new XAResource[size];
                for (int i = 0; i < size; ++i) {
                    xaresArray[i] = (XAResource)xaresList.elementAt(i);
                }
                this.resourceRecoveryStarted();
                if (_logger.isLoggable(Level.FINE)) {
                    String msg = localStrings.getStringWithDefault("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
                    _logger.log(Level.FINE, msg);
                }
                this.eeTransactionManager.recover(xaresArray);
                this.resourceRecoveryCompleted();
                this.closeAllResources(resourcesToHandler);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "xaresource.recover_error", ex);
            }
        }
    }

    private void resourceRecoveryStarted() {
        for (RecoveryResourceListener listener : this.recoveryListenersRegistry.getListeners()) {
            listener.recoveryStarted();
        }
    }

    private void resourceRecoveryCompleted() {
        for (RecoveryResourceListener listeners : this.recoveryListenersRegistry.getListeners()) {
            listeners.recoveryCompleted();
        }
    }

    private void beforeRecovery(boolean delegated, String instance) {
        for (RecoveryEventListener listener : this.recoveryListenersRegistry.getEventListeners()) {
            try {
                listener.beforeRecovery(delegated, instance);
            }
            catch (Throwable e) {
                _logger.log(Level.WARNING, "", e);
                _logger.log(Level.WARNING, "jts.before_recovery_excep", e);
            }
        }
    }

    private void afterRecovery(boolean success, boolean delegated, String instance) {
        for (RecoveryEventListener listener : this.recoveryListenersRegistry.getEventListeners()) {
            try {
                listener.afterRecovery(success, delegated, instance);
            }
            catch (Throwable e) {
                _logger.log(Level.WARNING, "", e);
                _logger.log(Level.WARNING, "jts.after_recovery_excep", e);
            }
        }
    }

    public void setLazyRecovery(boolean lazy) {
        this.lazyRecovery = lazy;
    }

    public void recoverXAResources() {
        this.recoverXAResources(!this.lazyRecovery);
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        this.recoveryResourceHandlers = new ArrayList<RecoveryResourceHandler>(this.serviceLocator.getAllServices(RecoveryResourceHandler.class, new Annotation[0]));
        this.recoveryResourceHandlers.addAll(externallyRegisteredRecoveryResourceHandlers);
        this.eeTransactionManager = (JavaEETransactionManager)this.serviceLocator.getService(JavaEETransactionManager.class, new Annotation[0]);
        this.recoveryListenersRegistry = (RecoveryResourceRegistry)this.serviceLocator.getService(RecoveryResourceRegistry.class, new Annotation[0]);
        if (this.recoveryListenersRegistry == null) {
            throw new IllegalStateException();
        }
        RecoveryManager.startTransactionRecoveryFence();
        this.configured = true;
    }

    public static void registerRecoveryResourceHandler(final XAResource xaResource) {
        RecoveryResourceHandler recoveryResourceHandler = new RecoveryResourceHandler(){

            public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
                xaresList.add(xaResource);
            }

            public void closeConnections(List connList) {
            }
        };
        externallyRegisteredRecoveryResourceHandlers.add(recoveryResourceHandler);
    }
}

