/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.util;

public final class PackagePrefixChecker {
    private static final String PACKAGE_PREFIX = "org.omg.stub.";
    private static final int PACKAGE_PREFIX_LENGTH = "org.omg.stub.".length();

    public static String packagePrefix() {
        return PACKAGE_PREFIX;
    }

    public static String correctPackageName(String p) {
        if (PackagePrefixChecker.isOffendingPackage(p)) {
            return PACKAGE_PREFIX + p;
        }
        return p;
    }

    public static boolean isOffendingPackage(String p) {
        return p != null && (p.equals("java") || p.equals("javax"));
    }

    public static boolean hasOffendingPrefix(String p) {
        return p.startsWith("java.") || p.startsWith("javax.");
    }

    public static boolean hasBeenPrefixed(String p) {
        return p.startsWith(PACKAGE_PREFIX);
    }

    public static String withoutPackagePrefix(String p) {
        if (PackagePrefixChecker.hasBeenPrefixed(p)) {
            return p.substring(PACKAGE_PREFIX_LENGTH);
        }
        return p;
    }
}

