/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.web.deployment.descriptor.WebFragmentDescriptor;

public class AbsoluteOrderingDescriptor
extends Descriptor {
    private static final Object OTHERS = new Object();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbsoluteOrderingDescriptor.class);
    private final List<Object> absOrder = new ArrayList<Object>();
    private boolean hasOthers;

    public void addName(String name) {
        if (!this.absOrder.add(name)) {
            throw new IllegalStateException(localStrings.getLocalString("web.deployment.exceptionalreadydefinedinabsoluteordering", "[{0}] has already been defined in the absolute-ordering.", new Object[]{name}));
        }
    }

    public void addOthers() {
        if (!this.absOrder.add(OTHERS)) {
            throw new IllegalStateException(localStrings.getLocalString("web.deployment.exceptionalreadydefinedinabsoluteordering", "[{0}] is already defined in the absolute-ordering.", new Object[]{"<others/>"}));
        }
        this.hasOthers = true;
    }

    public List<Object> getOrdering() {
        return Collections.unmodifiableList(this.absOrder);
    }

    public boolean hasOthers() {
        return this.hasOthers;
    }

    public List<WebFragmentDescriptor> order(List<WebFragmentDescriptor> wfs) {
        ArrayList<WebFragmentDescriptor> wfList = new ArrayList<WebFragmentDescriptor>();
        if (wfs != null && !wfs.isEmpty()) {
            HashMap<String, WebFragmentDescriptor> map = new HashMap<String, WebFragmentDescriptor>();
            ArrayList<WebFragmentDescriptor> othersList = new ArrayList<WebFragmentDescriptor>();
            for (WebFragmentDescriptor wf : wfs) {
                String name = wf.getName();
                if (name != null && name.length() > 0 && this.absOrder.contains(name)) {
                    map.put(name, wf);
                    continue;
                }
                othersList.add(wf);
            }
            for (Object obj : this.absOrder) {
                if (obj instanceof String) {
                    WebFragmentDescriptor wf = (WebFragmentDescriptor)((Object)map.get(obj));
                    if (wf == null) continue;
                    wfList.add(wf);
                    continue;
                }
                for (WebFragmentDescriptor wf : othersList) {
                    wfList.add(wf);
                }
            }
        }
        return wfList;
    }
}

