/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionUtils {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Map<ClassLoader, ConcurrentMap<String, MetaData>> REFLECTION_CACHE = new WeakHashMap<ClassLoader, ConcurrentMap<String, MetaData>>();

    private ReflectionUtils() {
    }

    public static void setProperties(Object object, Map<String, Object> propertiesToSet) {
        try {
            HashMap<String, PropertyDescriptor> availableProperties = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                availableProperties.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            for (Map.Entry entry : propertiesToSet.entrySet()) {
                ((PropertyDescriptor)availableProperties.get(entry.getKey())).getWriteMethod().invoke(object, entry.getValue());
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setPropertiesWithCoercion(Object object, Map<String, Object> propertiesToSet) {
        try {
            for (PropertyDescriptor property : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                Method setter = property.getWriteMethod();
                if (setter == null || !propertiesToSet.containsKey(property.getName())) continue;
                Object value = propertiesToSet.get(property.getName());
                if (value instanceof String && !property.getPropertyType().equals(String.class)) {
                    PropertyEditor editor = PropertyEditorManager.findEditor(property.getPropertyType());
                    editor.setAsText((String)value);
                    value = editor.getValue();
                }
                property.getWriteMethod().invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Method findMethod(Object base, String methodName, Object[] params) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : base.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != params.length) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if (methods.size() > 1) {
            for (Method method : methods) {
                boolean match = true;
                Class<?>[] candidateParams = method.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    if (candidateParams[i].isInstance(params[i])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    public static Class<?> toClass(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (Exception ignore) {
                Object var2_3 = null;
                throw new IllegalStateException(e);
            }
        }
    }

    public static Optional<Class<?>> findClass(String className) {
        try {
            return Optional.of(ReflectionUtils.toClass(className));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> T instance(String className) {
        return (T)ReflectionUtils.instance(ReflectionUtils.toClass(className));
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static synchronized void clearCache(ClassLoader loader) {
        REFLECTION_CACHE.remove(loader);
    }

    public static synchronized void initCache(ClassLoader loader) {
        if (REFLECTION_CACHE.get(loader) == null) {
            REFLECTION_CACHE.put(loader, new ConcurrentHashMap());
        }
    }

    public static Constructor<?> lookupConstructor(Class<?> clazz, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupConstructor(params);
    }

    public static Method lookupMethod(Object object, String methodName, Class<?> ... params) {
        Class<?> clazz = object.getClass();
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupMethod(methodName, params);
    }

    public static Method lookupMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupMethod(methodName, params);
    }

    public static Object newInstance(String className) throws IllegalArgumentException, ReflectiveOperationException, SecurityException {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Class<?> lookupClass(String className) {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass();
    }

    public static Method lookupWriteMethod(String className, String propertyName) {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupWriteMethod(propertyName);
    }

    public static Method lookupReadMethod(String className, String propertyName) {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupReadMethod(propertyName);
    }

    private static MetaData getMetaData(ClassLoader loader, Class<?> clazz) {
        MetaData meta;
        ConcurrentMap<String, MetaData> cache = REFLECTION_CACHE.get(loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = REFLECTION_CACHE.get(loader);
        }
        if ((meta = (MetaData)cache.get(clazz.getName())) == null) {
            meta = new MetaData(clazz);
            cache.put(clazz.getName(), meta);
        }
        return meta;
    }

    private static MetaData getMetaData(ClassLoader loader, String className) {
        MetaData meta;
        ConcurrentMap<String, MetaData> cache = REFLECTION_CACHE.get(loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = REFLECTION_CACHE.get(loader);
        }
        if ((meta = (MetaData)cache.get(className)) == null) {
            try {
                Class clazz = Util.loadClass(className, cache);
                meta = new MetaData(clazz);
                cache.put(className, meta);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return meta;
    }

    private static final class MetaData {
        Map<Integer, Constructor> constructors;
        Map<String, HashMap<Integer, Method>> methods;
        Map<String, HashMap<Integer, Method>> declaredMethods;
        Map<String, PropertyDescriptor> propertyDescriptors;
        Class<?> clazz;

        public MetaData(Class<?> clazz) {
            block10: {
                String name;
                int i;
                this.clazz = clazz;
                Constructor<?>[] ctors = clazz.getConstructors();
                this.constructors = new HashMap<Integer, Constructor>(ctors.length, 1.0f);
                int len = ctors.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    this.constructors.put(MetaData.getKey(ctors[i2].getParameterTypes()), ctors[i2]);
                }
                Method[] meths = clazz.getMethods();
                this.methods = new HashMap<String, HashMap<Integer, Method>>(meths.length, 1.0f);
                int len2 = meths.length;
                for (i = 0; i < len2; ++i) {
                    name = meths[i].getName();
                    HashMap<Integer, Method> methodsMap = this.methods.get(name);
                    if (methodsMap == null) {
                        methodsMap = new HashMap(4, 1.0f);
                        this.methods.put(name, methodsMap);
                    }
                    methodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
                }
                meths = clazz.getDeclaredMethods();
                this.declaredMethods = new HashMap<String, HashMap<Integer, Method>>(meths.length, 1.0f);
                len2 = meths.length;
                for (i = 0; i < len2; ++i) {
                    name = meths[i].getName();
                    HashMap<Integer, Method> declaredMethodsMap = this.declaredMethods.get(name);
                    if (declaredMethodsMap == null) {
                        declaredMethodsMap = new HashMap(4, 1.0f);
                        this.declaredMethods.put(name, declaredMethodsMap);
                    }
                    declaredMethodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
                }
                try {
                    BeanInfo info = Introspector.getBeanInfo(clazz);
                    PropertyDescriptor[] pds = info.getPropertyDescriptors();
                    if (pds != null) {
                        if (this.propertyDescriptors == null) {
                            this.propertyDescriptors = new HashMap<String, PropertyDescriptor>(pds.length, 1.0f);
                        }
                        for (PropertyDescriptor pd : pds) {
                            this.propertyDescriptors.put(pd.getName(), pd);
                        }
                    }
                }
                catch (IntrospectionException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                }
            }
        }

        public Constructor<?> lookupConstructor(Class<?> ... params) {
            return this.constructors.get(MetaData.getKey(params));
        }

        public Method lookupMethod(String name, Class<?> ... params) {
            Map map = this.methods.get(name);
            Integer key = MetaData.getKey(params);
            Method result = null;
            if ((null == map || null == (result = (Method)map.get(key))) && null != (map = (Map)this.declaredMethods.get(name))) {
                result = (Method)map.get(key);
            }
            return result;
        }

        public Class<?> lookupClass() {
            return this.clazz;
        }

        public Method lookupWriteMethod(String propName) {
            if (this.propertyDescriptors == null) {
                return null;
            }
            PropertyDescriptor pd = this.propertyDescriptors.get(propName);
            if (pd != null) {
                return pd.getWriteMethod();
            }
            return null;
        }

        public Method lookupReadMethod(String propName) {
            if (this.propertyDescriptors == null) {
                return null;
            }
            PropertyDescriptor pd = this.propertyDescriptors.get(propName);
            if (pd != null) {
                return pd.getReadMethod();
            }
            return null;
        }

        private static Integer getKey(Class<?> ... params) {
            return Arrays.deepHashCode(params);
        }
    }
}

