/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.AsadminSecurityUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.security.KeyTool;

public class AsadminTruststore {
    private static final String ASADMIN_TRUSTSTORE = "truststore.p12";
    private final File keyFile = AsadminTruststore.getAsadminTruststore();
    private final char[] password;
    private final KeyStore keyStore;

    public static AsadminTruststore newInstance() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(true).getAsadminTruststore();
    }

    public static AsadminTruststore newInstance(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(password, true).getAsadminTruststore();
    }

    AsadminTruststore(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.password = password;
        if (this.keyFile.exists()) {
            this.keyStore = new KeyTool(this.keyFile, password).loadKeyStore();
        } else {
            this.keyStore = KeyStore.getInstance("PKCS12");
            this.keyStore.load(null, password);
        }
    }

    public boolean certificateExists(Certificate cert) throws KeyStoreException {
        return this.keyStore.getCertificateAlias(cert) != null;
    }

    public void addCertificate(String alias, Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStore.setCertificateEntry(alias, cert);
        this.writeStore();
    }

    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (BufferedOutputStream boutput = new BufferedOutputStream(new FileOutputStream(this.keyFile));){
            this.keyStore.store(boutput, this.password);
        }
    }

    private static File getAsadminTruststore() {
        String location = System.getProperty(GlassFishVariable.TRUSTSTORE_FILE.getSystemPropertyName());
        if (location == null) {
            return new File(AsadminSecurityUtil.GF_CLIENT_DIR, ASADMIN_TRUSTSTORE);
        }
        return new File(location);
    }
}

