/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataFilter;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.AbstractTableDataProvider;
import java.io.Serializable;
import java.util.ArrayList;

public class FilteredTableDataProvider
extends AbstractTableDataProvider {
    protected TableDataProvider provider;
    protected TableDataFilter filter;
    private DataEars dataEars = new DataEars();
    private FilterMap filterMap = new FilterMap();

    public void setTableDataProvider(TableDataProvider provider) {
        if (this.provider != null) {
            this.provider.removeTableDataListener(this.dataEars);
        }
        this.provider = provider;
        this.provider.addTableDataListener(this.dataEars);
        this.filterMap.reset();
        this.fireProviderChanged();
    }

    public TableDataProvider getTableDataProvider() {
        return this.provider;
    }

    public void setTableDataFilter(TableDataFilter filter) {
        this.filter = filter;
        this.filterMap.reset();
        this.fireProviderChanged();
    }

    public TableDataFilter getTableDataFilter() {
        return this.filter;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.provider == null) {
            return FieldKey.EMPTY_ARRAY;
        }
        return this.provider.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getFieldKey(fieldId);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getType(fieldKey);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            return true;
        }
        return this.provider.isReadOnly(fieldKey);
    }

    public int getRowCount() throws DataProviderException {
        if (this.provider == null) {
            return 0;
        }
        return this.filterMap.getRowCount();
    }

    public RowKey[] getRowKeys(int count, RowKey afterRow) throws DataProviderException {
        if (this.provider == null) {
            return RowKey.EMPTY_ARRAY;
        }
        return this.filterMap.getRowKeys(count, afterRow);
    }

    public RowKey getRowKey(String rowId) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getRowKey(rowId);
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.filterMap.isIncluded(row) && this.provider.isRowAvailable(row);
    }

    public Object getValue(FieldKey fieldKey, RowKey row) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getValue(fieldKey, row);
    }

    public void setValue(FieldKey fieldKey, RowKey row, Object value) throws DataProviderException {
        if (this.provider == null) {
            return;
        }
        this.filterMap.reset();
        this.provider.setValue(fieldKey, row, value);
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canInsertRow(beforeRow);
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        this.filterMap.reset();
        return this.provider.insertRow(beforeRow);
    }

    public boolean canAppendRow() throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canAppendRow();
    }

    public RowKey appendRow() throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        this.filterMap.reset();
        return this.provider.appendRow();
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canRemoveRow(row);
    }

    public void removeRow(RowKey row) throws DataProviderException {
        if (this.provider != null) {
            this.filterMap.reset();
            this.provider.removeRow(row);
        }
    }

    public boolean cursorFirst() throws DataProviderException {
        RowKey first = this.filterMap.findFirst();
        if (first != null) {
            try {
                this.setCursorRow(first);
                return true;
            }
            catch (TableCursorVetoException x) {
                return false;
            }
        }
        return false;
    }

    public boolean cursorPrevious() throws DataProviderException {
        RowKey previous;
        RowKey cursor = this.getCursorRow();
        RowKey rowKey = previous = cursor != null ? this.filterMap.findPrevious(cursor) : this.filterMap.findFirst();
        if (previous != null) {
            try {
                this.setCursorRow(previous);
                return true;
            }
            catch (TableCursorVetoException x) {
                return false;
            }
        }
        return false;
    }

    public boolean cursorNext() throws DataProviderException {
        RowKey next;
        RowKey cursor = this.getCursorRow();
        RowKey rowKey = next = cursor != null ? this.filterMap.findNext(cursor) : this.filterMap.findLast();
        if (next != null) {
            try {
                this.setCursorRow(next);
                return true;
            }
            catch (TableCursorVetoException x) {
                return false;
            }
        }
        return false;
    }

    public boolean cursorLast() throws DataProviderException {
        RowKey last = this.filterMap.findLast();
        if (last != null) {
            try {
                this.setCursorRow(last);
                return true;
            }
            catch (TableCursorVetoException x) {
                return false;
            }
        }
        return false;
    }

    private class FilterMap
    implements Serializable {
        private ArrayList allRows = null;
        private ArrayList filterRows = null;

        private FilterMap() {
        }

        public int getRowCount() {
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            return this.filterRows.size();
        }

        private void scanAndFilterRows() {
            this.allRows = new ArrayList();
            this.filterRows = new ArrayList();
            if (FilteredTableDataProvider.this.provider == null) {
                return;
            }
            int count = FilteredTableDataProvider.this.provider.getRowCount();
            if (count < 0) {
                count = 10000;
            }
            RowKey[] rows = FilteredTableDataProvider.this.provider.getRowKeys(count, null);
            for (int i = 0; i < rows.length; ++i) {
                this.allRows.add(rows[i]);
            }
            RowKey[] frows = FilteredTableDataProvider.this.filter.filter(FilteredTableDataProvider.this.provider, rows);
            for (int i = 0; i < frows.length; ++i) {
                this.filterRows.add(frows[i]);
            }
            boolean cursorOk = false;
            boolean altCursorFound = false;
            RowKey cursor = FilteredTableDataProvider.this.getCursorRow();
            if (this.filterRows.contains(cursor)) {
                cursorOk = true;
            } else if (this.allRows.contains(cursor)) {
                int index = this.allRows.indexOf(cursor);
                for (int i = index + 1; i < this.allRows.size(); ++i) {
                    if (!this.filterRows.contains(this.allRows.get(i))) continue;
                    cursor = (RowKey)this.allRows.get(i);
                    altCursorFound = true;
                    break;
                }
            }
            if (!cursorOk) {
                if (!altCursorFound) {
                    cursor = this.findFirst();
                }
                try {
                    if (cursor != null) {
                        FilteredTableDataProvider.this.setCursorRow(cursor);
                    }
                }
                catch (TableCursorVetoException x) {
                    // empty catch block
                }
            }
        }

        public boolean isIncluded(RowKey row) {
            if (FilteredTableDataProvider.this.filter == null || FilteredTableDataProvider.this.provider == null) {
                return true;
            }
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            return this.filterRows.contains(row);
        }

        public RowKey[] getRowKeys(int count, RowKey afterRow) {
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            int startIndex = 0;
            if (afterRow != null) {
                for (int i = 0; i < this.filterRows.size(); ++i) {
                    if (!afterRow.equals(this.filterRows.get(i))) continue;
                    startIndex = i + 1;
                    break;
                }
            }
            ArrayList rows = new ArrayList();
            for (int i = startIndex; i < count; ++i) {
                if (i >= this.filterRows.size()) continue;
                rows.add(this.filterRows.get(i));
            }
            return rows.toArray(new RowKey[rows.size()]);
        }

        public RowKey findFirst() {
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            if (this.filterRows.size() > 0) {
                return (RowKey)this.filterRows.get(0);
            }
            return null;
        }

        public RowKey findPrevious(RowKey row) {
            int index;
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            if ((index = this.filterRows.indexOf(row)) > 0) {
                return (RowKey)this.filterRows.get(index - 1);
            }
            if (index < 0 && (index = this.allRows.indexOf(row)) > -1) {
                for (int i = index - 1; i >= 0; --i) {
                    if (!this.filterRows.contains(this.allRows.get(i))) continue;
                    return (RowKey)this.allRows.get(i);
                }
            }
            return this.findFirst();
        }

        public RowKey findNext(RowKey row) {
            int index;
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            if ((index = this.filterRows.indexOf(row)) >= 0 && index + 1 < this.filterRows.size()) {
                return (RowKey)this.filterRows.get(index + 1);
            }
            if (index < 0 && (index = this.allRows.indexOf(row)) > -1) {
                for (int i = index + 1; i < this.allRows.size(); ++i) {
                    if (!this.filterRows.contains(this.allRows.get(i))) continue;
                    return (RowKey)this.allRows.get(i);
                }
            }
            return this.findLast();
        }

        public RowKey findLast() {
            if (this.filterRows == null) {
                this.scanAndFilterRows();
            }
            if (this.filterRows.size() > 0) {
                return (RowKey)this.filterRows.get(this.filterRows.size() - 1);
            }
            return null;
        }

        public void reset() {
            this.allRows = null;
            this.filterRows = null;
        }
    }

    private class DataEars
    implements TableDataListener,
    Serializable {
        private DataEars() {
        }

        public void valueChanged(TableDataProvider provider, FieldKey fieldKey, RowKey row, Object oldValue, Object newValue) {
            FilteredTableDataProvider.this.filterMap.reset();
            FilteredTableDataProvider.this.fireValueChanged(fieldKey, row, oldValue, newValue);
        }

        public void rowAdded(TableDataProvider provider, RowKey row) {
            FilteredTableDataProvider.this.filterMap.reset();
            FilteredTableDataProvider.this.fireRowAdded(row);
        }

        public void rowRemoved(TableDataProvider provider, RowKey row) {
            FilteredTableDataProvider.this.filterMap.reset();
            FilteredTableDataProvider.this.fireRowRemoved(row);
        }

        public void valueChanged(DataProvider provider, FieldKey fieldKey, Object oldValue, Object newValue) {
            FilteredTableDataProvider.this.filterMap.reset();
            FilteredTableDataProvider.this.fireValueChanged(fieldKey, oldValue, newValue);
        }

        public void providerChanged(DataProvider provider) {
            FilteredTableDataProvider.this.filterMap.reset();
            FilteredTableDataProvider.this.fireProviderChanged();
        }
    }
}

