/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer.types;

import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.yasson.internal.BuiltInTypes;
import org.eclipse.yasson.internal.JsonbConfigProperties;
import org.eclipse.yasson.internal.deserializer.JustReturn;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;
import org.eclipse.yasson.internal.deserializer.NullCheckDeserializer;
import org.eclipse.yasson.internal.deserializer.PositionChecker;
import org.eclipse.yasson.internal.deserializer.ValueExtractor;
import org.eclipse.yasson.internal.deserializer.types.BigDecimalDeserializer;
import org.eclipse.yasson.internal.deserializer.types.BigIntegerDeserializer;
import org.eclipse.yasson.internal.deserializer.types.BooleanDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ByteDeserializer;
import org.eclipse.yasson.internal.deserializer.types.CalendarDeserializer;
import org.eclipse.yasson.internal.deserializer.types.CharDeserializer;
import org.eclipse.yasson.internal.deserializer.types.DateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.DoubleDeserializer;
import org.eclipse.yasson.internal.deserializer.types.DurationDeserializer;
import org.eclipse.yasson.internal.deserializer.types.EnumDeserializer;
import org.eclipse.yasson.internal.deserializer.types.FloatDeserializer;
import org.eclipse.yasson.internal.deserializer.types.InstantDeserializer;
import org.eclipse.yasson.internal.deserializer.types.IntegerDeserializer;
import org.eclipse.yasson.internal.deserializer.types.JsonValueDeserializer;
import org.eclipse.yasson.internal.deserializer.types.LocalDateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.LocalDateTimeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.LocalTimeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.LongDeserializer;
import org.eclipse.yasson.internal.deserializer.types.MonthDayTypeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.NumberDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ObjectTypeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.OffsetDateTimeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.OffsetTimeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.OptionalDoubleDeserializer;
import org.eclipse.yasson.internal.deserializer.types.OptionalIntDeserializer;
import org.eclipse.yasson.internal.deserializer.types.OptionalLongDeserializer;
import org.eclipse.yasson.internal.deserializer.types.PathDeserializer;
import org.eclipse.yasson.internal.deserializer.types.PeriodDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ShortDeserializer;
import org.eclipse.yasson.internal.deserializer.types.SqlDateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.SqlTimestampDeserializer;
import org.eclipse.yasson.internal.deserializer.types.StringDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TimeZoneDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializerBuilder;
import org.eclipse.yasson.internal.deserializer.types.UriDeserializer;
import org.eclipse.yasson.internal.deserializer.types.UrlDeserializer;
import org.eclipse.yasson.internal.deserializer.types.UuidDeserializer;
import org.eclipse.yasson.internal.deserializer.types.XmlGregorianCalendarDeserializer;
import org.eclipse.yasson.internal.deserializer.types.YearMonthTypeDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ZoneIdDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ZoneOffsetDeserializer;
import org.eclipse.yasson.internal.deserializer.types.ZonedDateTimeDeserializer;
import org.eclipse.yasson.internal.model.customization.Customization;

public class TypeDeserializers {
    private static final Map<Class<?>, Function<TypeDeserializerBuilder, TypeDeserializer>> DESERIALIZERS = new HashMap();
    private static final Map<Class<?>, Class<?>> OPTIONAL_TYPES = new HashMap();

    private TypeDeserializers() {
        throw new IllegalStateException("Utility classes cannot be instantiated");
    }

    public static ModelDeserializer<JsonParser> getTypeDeserializer(Class<?> clazz, Customization customization, JsonbConfigProperties properties, ModelDeserializer<Object> delegate, Set<JsonParser.Event> events) {
        JsonParser.Event[] eventArray = events.toArray(new JsonParser.Event[0]);
        if (OPTIONAL_TYPES.containsKey(clazz)) {
            Class<?> optionalType = OPTIONAL_TYPES.get(clazz);
            TypeDeserializerBuilder builder = new TypeDeserializerBuilder(optionalType, customization, properties, JustReturn.instance());
            ValueExtractor valueExtractor = new ValueExtractor(DESERIALIZERS.get(optionalType).apply(builder));
            PositionChecker positionChecker = new PositionChecker((ModelDeserializer<JsonParser>)valueExtractor, clazz, eventArray);
            if (OptionalLong.class.equals(clazz)) {
                return new OptionalLongDeserializer(positionChecker, delegate);
            }
            if (OptionalInt.class.equals(clazz)) {
                return new OptionalIntDeserializer(positionChecker, delegate);
            }
            if (OptionalDouble.class.equals(clazz)) {
                return new OptionalDoubleDeserializer(positionChecker, delegate);
            }
            throw new JsonbException("Unsupported Optional type for deserialization: " + clazz);
        }
        TypeDeserializerBuilder builder = new TypeDeserializerBuilder(clazz, customization, properties, delegate);
        if (DESERIALIZERS.containsKey(clazz)) {
            ValueExtractor valueExtractor = new ValueExtractor(DESERIALIZERS.get(clazz).apply(builder));
            return new NullCheckDeserializer(new PositionChecker((ModelDeserializer<JsonParser>)valueExtractor, clazz, eventArray), delegate);
        }
        if (JsonValue.class.equals(clazz)) {
            return new JsonValueDeserializer(builder, JsonValue.NULL);
        }
        if (JsonValue.class.isAssignableFrom(clazz)) {
            return new JsonValueDeserializer(builder, null);
        }
        ModelDeserializer<JsonParser> deserializer = TypeDeserializers.assignableCases(builder, eventArray);
        if (deserializer != null) {
            return new NullCheckDeserializer(deserializer, delegate);
        }
        return null;
    }

    private static ModelDeserializer<JsonParser> assignableCases(TypeDeserializerBuilder builder, JsonParser.Event[] checker) {
        if (Enum.class.isAssignableFrom(builder.getClazz())) {
            return new PositionChecker((ModelDeserializer<JsonParser>)new ValueExtractor(new EnumDeserializer(builder)), builder.getClazz(), checker);
        }
        if (Object.class.equals(builder.getClazz())) {
            return new ObjectTypeDeserializer(builder);
        }
        return null;
    }

    static {
        DESERIALIZERS.put(BigInteger.class, BigIntegerDeserializer::new);
        DESERIALIZERS.put(BigDecimal.class, BigDecimalDeserializer::new);
        DESERIALIZERS.put(Boolean.class, BooleanDeserializer::new);
        DESERIALIZERS.put(Boolean.TYPE, BooleanDeserializer::new);
        DESERIALIZERS.put(Byte.class, ByteDeserializer::new);
        DESERIALIZERS.put(Byte.TYPE, ByteDeserializer::new);
        DESERIALIZERS.put(Calendar.class, CalendarDeserializer::new);
        DESERIALIZERS.put(Character.TYPE, CharDeserializer::new);
        DESERIALIZERS.put(Character.class, CharDeserializer::new);
        DESERIALIZERS.put(Date.class, DateDeserializer::new);
        DESERIALIZERS.put(Double.class, DoubleDeserializer::new);
        DESERIALIZERS.put(Double.TYPE, DoubleDeserializer::new);
        DESERIALIZERS.put(Duration.class, DurationDeserializer::new);
        DESERIALIZERS.put(Float.class, FloatDeserializer::new);
        DESERIALIZERS.put(Float.TYPE, FloatDeserializer::new);
        DESERIALIZERS.put(GregorianCalendar.class, CalendarDeserializer::new);
        DESERIALIZERS.put(Instant.class, InstantDeserializer::new);
        DESERIALIZERS.put(Integer.class, IntegerDeserializer::new);
        DESERIALIZERS.put(Integer.TYPE, IntegerDeserializer::new);
        DESERIALIZERS.put(LocalDate.class, LocalDateDeserializer::new);
        DESERIALIZERS.put(LocalDateTime.class, LocalDateTimeDeserializer::new);
        DESERIALIZERS.put(LocalTime.class, LocalTimeDeserializer::new);
        DESERIALIZERS.put(Long.class, LongDeserializer::new);
        DESERIALIZERS.put(Long.TYPE, LongDeserializer::new);
        DESERIALIZERS.put(MonthDay.class, MonthDayTypeDeserializer::new);
        DESERIALIZERS.put(Number.class, NumberDeserializer::new);
        DESERIALIZERS.put(OffsetDateTime.class, OffsetDateTimeDeserializer::new);
        DESERIALIZERS.put(OffsetTime.class, OffsetTimeDeserializer::new);
        DESERIALIZERS.put(Path.class, PathDeserializer::new);
        DESERIALIZERS.put(Period.class, PeriodDeserializer::new);
        DESERIALIZERS.put(Short.class, ShortDeserializer::new);
        DESERIALIZERS.put(Short.TYPE, ShortDeserializer::new);
        DESERIALIZERS.put(String.class, StringDeserializer::new);
        DESERIALIZERS.put(SimpleTimeZone.class, TimeZoneDeserializer::new);
        DESERIALIZERS.put(TimeZone.class, TimeZoneDeserializer::new);
        DESERIALIZERS.put(URI.class, UriDeserializer::new);
        DESERIALIZERS.put(URL.class, UrlDeserializer::new);
        DESERIALIZERS.put(UUID.class, UuidDeserializer::new);
        if (BuiltInTypes.isClassAvailable("javax.xml.datatype.XMLGregorianCalendar")) {
            DESERIALIZERS.put(XMLGregorianCalendar.class, XmlGregorianCalendarDeserializer::new);
        }
        DESERIALIZERS.put(YearMonth.class, YearMonthTypeDeserializer::new);
        DESERIALIZERS.put(ZonedDateTime.class, ZonedDateTimeDeserializer::new);
        DESERIALIZERS.put(ZoneId.class, ZoneIdDeserializer::new);
        DESERIALIZERS.put(ZoneOffset.class, ZoneOffsetDeserializer::new);
        if (BuiltInTypes.isClassAvailable("java.sql.Date")) {
            DESERIALIZERS.put(java.sql.Date.class, SqlDateDeserializer::new);
            DESERIALIZERS.put(Timestamp.class, SqlTimestampDeserializer::new);
        }
        OPTIONAL_TYPES.put(OptionalLong.class, Long.class);
        OPTIONAL_TYPES.put(OptionalInt.class, Integer.class);
        OPTIONAL_TYPES.put(OptionalDouble.class, Double.class);
    }
}

