/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.types;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum StandardContextType implements ConcurrencyContextType
{
    Remaining,
    Classloader,
    JNDI,
    Security,
    WorkArea;


    public static Set<String> names() {
        return Arrays.stream(StandardContextType.values()).map(Enum::name).collect(Collectors.toSet());
    }

    public static StandardContextType parse(String name) {
        for (StandardContextType ctxType : StandardContextType.values()) {
            if (!ctxType.name().equalsIgnoreCase(name)) continue;
            return ctxType;
        }
        if ("NAMING".equalsIgnoreCase(name)) {
            return JNDI;
        }
        if ("CLASSLOADING".equalsIgnoreCase(name)) {
            return Classloader;
        }
        return null;
    }
}

