/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.glassfish.resources.api.Resource;

public final class ResourceAttributes {
    private final Map<String, String> strings = new HashMap<String, String>();
    private final Map<String, String[]> stringArrays = new HashMap<String, String[]>();
    private final Map<String, Properties> properties = new HashMap<String, Properties>();

    public String getString(String name) {
        Objects.requireNonNull(name, "name");
        return this.strings.get(name);
    }

    public Map<String, String> getStrings() {
        return Collections.unmodifiableMap(this.strings);
    }

    public String[] getStringArray(String name) {
        Objects.requireNonNull(name, "name");
        return this.stringArrays.get(name);
    }

    public Properties getProperties(String name) {
        Objects.requireNonNull(name, "name");
        return this.properties.get(name);
    }

    public void set(String name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(name, "value");
        this.strings.put(name, value);
    }

    public void set(String name, String[] value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(name, "value");
        this.stringArrays.put(name, value);
    }

    public void set(String name, Properties value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(name, "value");
        this.properties.put(name, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        ResourceAttributes other = (ResourceAttributes)obj;
        return this.strings.equals(other.strings) && this.stringArrays.equals(other.stringArrays) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.strings, this.stringArrays, this.properties);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName()).append('[');
        for (Map.Entry<String, String> entry : this.strings.entrySet()) {
            str.append('\n').append(entry.getKey()).append('=').append(entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.stringArrays.entrySet()) {
            str.append('\n').append(entry.getKey()).append('=').append(Arrays.toString((Object[])entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            str.append('\n').append(entry.getKey()).append("=").append(entry.getValue());
        }
        str.append('\n').append(']');
        return str.toString();
    }
}

