/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.VersionExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class JPQLFunctionsAbstractBuilder
extends EclipseLinkAnonymousExpressionVisitor {
    final JPQLQueryContext queryContext;

    protected JPQLFunctionsAbstractBuilder(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    public void visit(IdExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        String variableText = identificationVariable.getText();
        String variableName = identificationVariable.getVariableName();
        ClassDescriptor descriptor = this.queryContext.getDeclaration(variableName).getDescriptor();
        List<DatabaseField> primaryKeyFields = descriptor.getPrimaryKeyFields();
        for (DatabaseField primaryKeyField : primaryKeyFields) {
            String idAttributeName = this.getIdAttributeNameByField(descriptor.getMappings(), primaryKeyField);
            StateFieldPathExpression stateFieldPathExpression = new StateFieldPathExpression(expression.getParent(), variableText + "." + idAttributeName);
            expression.addStateFieldPathExpression(stateFieldPathExpression);
        }
        for (Expression fieldPathExpression : expression.getStateFieldPathExpressions()) {
            fieldPathExpression.accept((ExpressionVisitor)this);
        }
    }

    public void visit(VersionExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        String variableText = identificationVariable.getText();
        String variableName = identificationVariable.getVariableName();
        ClassDescriptor descriptor = this.queryContext.getDeclaration(variableName).getDescriptor();
        String versionAttributeName = ((VersionLockingPolicy)descriptor.getOptimisticLockingPolicy()).getVersionMapping().getAttributeName();
        StateFieldPathExpression stateFieldPathExpression = new StateFieldPathExpression(expression.getParent(), variableText + "." + versionAttributeName);
        expression.setStateFieldPathExpression(stateFieldPathExpression);
        expression.getStateFieldPathExpression().accept((ExpressionVisitor)this);
    }

    private String getIdAttributeNameByField(List<DatabaseMapping> databaseMappings, DatabaseField field) {
        for (DatabaseMapping mapping : databaseMappings) {
            if (mapping.getFields().size() > 1 && (field.equals(mapping.getField()) || mapping.isPrimaryKeyMapping())) {
                return mapping.getAttributeName();
            }
            if (field.equals(mapping.getField()) && mapping.isPrimaryKeyMapping()) {
                return mapping.getAttributeName();
            }
            if (!field.equals(mapping.getField())) continue;
            return mapping.getAttributeName();
        }
        return null;
    }
}

