/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.QueueableWeakCacheKey;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class WeakUnitOfWorkIdentityMap
extends UnitOfWorkIdentityMap {
    protected ReferenceQueue referenceQueue;
    protected volatile int cleanupCount = 0;
    protected volatile int cleanupSize;

    public WeakUnitOfWorkIdentityMap(int size, ClassDescriptor descriptor, AbstractSession session, boolean isolated) {
        super(size, descriptor, session, isolated);
        this.cleanupSize = size;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void cleanupDeadCacheKeys() {
        Reference reference = this.referenceQueue.poll();
        while (reference != null) {
            QueueableWeakCacheKey key = ((QueueableWeakCacheKey.CacheKeyReference)reference.get()).getOwner();
            this.remove(key);
            reference = this.referenceQueue.poll();
        }
    }

    @Override
    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new QueueableWeakCacheKey(primaryKey, object, writeLockValue, readTime, this.referenceQueue, this.isIsolated);
    }

    @Override
    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        CacheKey cacheKey = super.putCacheKeyIfAbsent(searchKey);
        if (cacheKey == null) {
            this.checkCleanup();
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanup() {
        if (this.cleanupCount > this.cleanupSize) {
            WeakUnitOfWorkIdentityMap weakUnitOfWorkIdentityMap = this;
            synchronized (weakUnitOfWorkIdentityMap) {
                if (this.cleanupCount > this.cleanupSize) {
                    this.cleanupDeadCacheKeys();
                    this.cleanupCount = 0;
                    int size = this.getSize();
                    if (size > this.cleanupSize) {
                        this.cleanupSize = size;
                    }
                }
            }
        }
        ++this.cleanupCount;
    }
}

